#include <iostream>

#include <boost/filesystem/path.hpp>
#include <boost/scoped_ptr.hpp>
#include <boost/timer.hpp>
#include <boost/progress.hpp>

#include <outilex/lingdef.h>
#include <outilex/sentence_fsa.h>

#include <outilex/text_fsa.h>

using namespace std;
using namespace boost;
namespace fs = boost::filesystem;

char * progname;

void usage() {
  cout << "usage: " << progname << " [-xml|-bin|-txt] <txtfsa>\n";
  exit(0);
}



int main(int argc, char ** argv) try {

  fs::path txtpath, lingdefpath;

  char * bla = getenv("LINGDEF");
  if (bla) {
    lingdefpath = fs::path(bla);
  }

  progname = *argv;
  argv++, argc--;

  if (argc == 0) { usage(); }

  while (argc) {

    string arg = *argv;

    if (arg == "-h") {

      usage();

    } else if (arg == "-l") {

      argv++, argc--;
      if (argc == 0) { cerr << "bad args\n"; exit(1); }
      lingdefpath = fs::path(*argv);

    } else {

      txtpath = fs::path(arg);
    }

    argv++, argc--;
  }

  if (lingdefpath.empty() || txtpath.empty()) {
    cerr << "bad args\n"; exit(1);
  }


  ling_def lingdef(lingdefpath);

  //itext_fsa * p_text = new_itext_fsa(txtpath, & lingdef);
  scoped_ptr<itext_fsa> p_text(new_itext_fsa(txtpath, & lingdef));
  itext_fsa & text = *p_text;

  int total = text.size();
  cout << total << " sentences expected.\n";

  sentence_fsa fsa;
  int sentenceno = 0;

  timer tmr;
  progress_display progress(total, cout);

  while (text >> fsa) { ++sentenceno; ++progress; }

  cout << "done. " << sentenceno << "/" << total << " sentences read. " << tmr.elapsed() << "s.\n";

} catch (exception & e) {
  cerr << "fatatl error : " << e.what() << endl;
  exit(1);
}

