#include <boost/lexical_cast.hpp>
#include <outilex/lexic.h>

using namespace std;
using namespace boost;


int mutable_lexic::add(const lexical_mask & m) {

  string text;
  {
    ostringstream oss;
    oss << m;
    text = oss.str();
  }

  key_map_type::iterator it = key_map.find(text);

  if (it != key_map.end()) { return it->second; }

  key_map[text] = tab.size();
  tab.push_back(m);
  return tab.size() - 1;
}


LEXIC::LEXIC(const mutable_lexic & lexic) : lex(new lexic_imp()) {

  int size = lexic.size();
  lex->tab.resize(size);
  for (int i = 0; i < size; ++i) {
    lex->tab[i] = lexic[i];
  }
}

