#include <iostream>
#include <sstream>
#include <cassert>
#include <iterator>
#include <vector>

#include <boost/lexical_cast.hpp>

#include <outilex/stringtok.h>
#include <outilex/synt_output.h>

using namespace std;
using namespace boost;

void synt_output::elem::dump_text(ostream & os) const {
  os << '(' << pos << ',' << v << ')';
}


void synt_output::elem::write_XML(xmlwriter & writer) const {
  writer.start_element("e");
  writer.write_attribute("val", v);
  writer.write_attribute("pos", lexical_cast<string>(pos));
  writer.end_element();
}

void synt_output::elem::read_XML(xmlNodePtr node) {
  char * text = (char *) xmlGetProp(node, (const xmlChar *) "val");
  v = text;
  xmlFree(text);
  text = (char *) xmlGetProp(node, (const xmlChar *) "pos");
  istringstream(text) >> pos;
  xmlFree(text);
}


void synt_output::read_text(const std::string & text) {

  inf = false;
  v.clear();

  vector<string> vec;
  stringtok(text, ",", back_inserter(vec));

  for (vector<string>::iterator it = vec.begin(); it != vec.end(); ++it) {
    v.insert(elem(*it));
  }
}



synt_output synt_output::mult(const synt_output & a, const synt_output & b) {
  synt_output res;
  if (a.inf || b.inf) {
    res.inf = true;
  } else {
    res.inf = false;
    set_union(a.v.begin(), a.v.end(), b.v.begin(), b.v.end(), inserter(res.v, res.v.begin()));
  }
  return res;
}

synt_output synt_output::plus(const synt_output & a, const synt_output & b) {

  if (a.inf) { return b; }
  if (b.inf) { return a; }

  synt_output res(false);
  set_intersection(a.v.begin(), a.v.end(), b.v.begin(), b.v.end(), inserter(res.v, res.v.begin()));
  return res;
}

synt_output synt_output::minus(const synt_output & a, const synt_output & b) {
  //cerr << "synt_output: minus:" << a << " minus " << b << " = ";
  assert(includes(a.v.begin(), a.v.end(), b.v.begin(), b.v.end()));
  synt_output res(false);
  set_difference(a.v.begin(), a.v.end(), b.v.begin(), b.v.end(), inserter(res.v, res.v.begin()));
  //cerr << res << endl;
  return res;
}

synt_output synt_output::delay() const {

  if (inf) { return synt_output(true); }

  synt_output res(false);

  for (set<elem>::const_iterator it = v.begin(); it != v.end(); ++it) {
    res.v.insert(it->delay());
  }
  return res;
}

void synt_output::dump_text(ostream & os) const {
  if (inf) { os << "<inf>"; return; }
  if (v.empty()) { os << "<zero>"; }
  for (set<elem>::const_iterator it = v.begin(); it != v.end(); ++it) {
    it->dump_text(os);
  }
}

void synt_output::write_XML(xmlwriter & writer) const {
  writer.start_element("synt_output");
  if (inf) {
    writer.write_element("inf");
  } else {
    for (set<elem>::const_iterator it = v.begin(); it != v.end(); ++it) {
      it->write_XML(writer);
    }
  }
  writer.end_element();
}


void synt_output::read_XML(xmlNodePtr node) {

  inf = false;
  v.clear();

  node = node->xmlChildrenNode;
  while (node) {
 
    if (xmlStrcmp(node->name, elem::xml_name()) == 0) {
      v.insert(elem(node));
    } else if (xmlStrcmp(node->name, (const xmlChar *) "inf") == 0) {
      //    cerr << "find INF!!!!!!\n";
      inf = true;
      v.clear();
      return;
    }
    node = node->next;
  }
}

