#include <string>
#include <map>

#include <outilex/feat_set.h>

#include <outilex/stringtok.h>
#include <outilex/xml.h>

#include <outilex/synt_mask.h>

using namespace std;
  
synt_mask::synt_mask(syntagm_def * sdef) : syntdef(sdef), dic_feats(), string_feats() {}
  

bool synt_mask::match(const syntagm_path & p) const {

  if (p.syntdef != syntdef) { return false; }

  for (dic_feats_map::const_iterator it = dic_feats.begin(); it != dic_feats.end(); ++it) {
    
    attr_def * attr = it->first;
    const feat_set & fs = it->second;

    syntagm_path::dic_feats_map::const_iterator it2 = p.dic_feats.find(attr); 
    if (it2 != p.dic_feats.end()) {
      if (! fs.match(it2->second)) { return false; }
    }
  }

#warning " syntmask::match : should check for string_feats too"
  return true;
}

void synt_mask::read_text(const string & txt, ling_def * lingdef) { /* <:GN+m+s> */

  int size = txt.size();
  assert((size > 2) && txt[0] == '<' && txt[1] == ':' && txt[size-1] == '>');

  vector<string> vec;
  stringtok(txt, "<:+>", back_inserter(vec));

  syntdef = lingdef->get_syntagm_def(vec[0]);
  if (syntdef == NULL) {
    syntdef = lingdef->add_syntagm_def(vec[0]);
  }

  for (int i = 1; i < vec.size(); ++i) {

    feat_set fs; attr_def * attr;

    if (! syntdef->get_feat_set(vec[i], attr, fs)) {
      cerr << "error with syntagm label : '" << txt << "': unknow feat :" << vec[i] << '\n';
      continue;
    }

    dic_feats_map::iterator it = dic_feats.find(attr);

    if (it == dic_feats.end()) {
      dic_feats[attr] = fs;
    } else {
      dic_feats[attr] |= fs;
    }
  }
}

void synt_mask::dump_text(ostream & os) const {
  os << "<:" << syntdef->get_name();
  for (dic_feats_map::const_iterator it = dic_feats.begin(); it != dic_feats.end(); ++it) {
    os << "+"; (*it).second.dump_text(os); 
  }
  os << ">";
}


void synt_mask::read_XML(xmlNodePtr node, ling_def * lingdef) {

  char * text = xmlGetProp(node, "name");

  syntdef = lingdef->get_syntagm_def(text);

  if (syntdef == NULL) {
    //cerr << "adding new syntagm def : " << text << endl;
    syntdef = lingdef->add_syntagm_def(text);
  }

  xmlFree(text);

  node = node->xmlChildrenNode;

  while (node) {

    if (xmlStrcmp(node->name, (const xmlChar *) "featset") == 0) {

      if ((text = xmlGetProp(node, "name")) == 0) {
        throw xml_parse_error("synt_mask::read_XML: invalid featset element");
      }

      attr_def * attr = syntdef->get_dic_attr(text);
      if (! attr) {
        throw xml_parse_error("synt_mask::read_XML: unknow attribute: " + string(text));
      }
      xmlFree(text);

      if ((text = xmlGetProp(node, "value")) == 0) {
        throw xml_parse_error("synt_mask::read_XML: invalid featset element");
      }

      feat_set fs(attr->get_type(), text);
      xmlFree(text);

      dic_feats[attr] = fs;

    } else if (xmlStrcmp(node->name, (const xmlChar *) "string_feat") == 0) {

      char * name  = (char *) xmlGetProp(node, (const xmlChar *) "name");
      char * value = (char *) xmlGetProp(node, (const xmlChar *) "value");

      string_feats[name] = value;

      xmlFree(name); xmlFree(value);
    }
    node = node->next;
  }
}

void synt_mask::write_XML(xmlwriter & writer) const {
  
  writer.start_element("syntagm_mask");
  writer.write_attribute("name", syntdef->get_name());

  for (dic_feats_map::const_iterator it = dic_feats.begin(); it != dic_feats.end(); ++it) {
    writer.start_element("featset");
    writer.write_attribute("name", it->first->get_name());
    writer.write_attribute("value", it->second.get_val_text());
    writer.end_element();
  }

  for (string_feats_map::const_iterator it = string_feats.begin(); it != string_feats.end(); ++it) {
    writer.start_element("string_feat");
    writer.write_attribute("name", it->first);
    writer.write_attribute("value", it->second);
    writer.end_element();
  }

  writer.end_element();
}

