#include <iostream>
#include <stack>

#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/fstream.hpp>
#include <boost/filesystem/convenience.hpp>
                       
#include <outilex/lingdef.h>
#include <outilex/syntagm_pattern.h>

using namespace std;

namespace fs = boost::filesystem;


char * progname;


void usage() {
  cerr << "usage: " << progname << " -l <lingdef> [-o <output> ] <pattern>\n";
  exit(1);
}


int main(int argc, char ** argv) try {

  string patternname, lingdefname, outputname;
  bool validate = false;

  progname = *argv;

  argv++, argc--;

  while (argc) {
    
    string arg = *argv;
    
    if (arg == "-l") {
      
      argv++, argc--;
      if (argc == 0) { usage(); }
      lingdefname = *argv;
    
    } else if (arg == "-o") {
      
      argv++, argc--;
      if (argc == 0) { usage(); }
      outputname = *argv;

    } else if (arg == "-h") {
    
      usage();
    
    } else {
      patternname = arg;
    }

    argv++, argc--;
  }

  if (patternname.empty() || lingdefname.empty()) { usage(); }


  xmlwriter writer;

  if (! outputname.empty()) {
    writer.open(outputname);
  } else {
    writer.open(cout);
  }


  ling_def * lingdef = new ling_def(lingdefname);

  fs::path path(patternname);
  syntagm_pattern pattern(path, lingdef);

  pattern.write_XML(writer);


  cout << "done.\n";
} catch (exception & e) {

  cerr << "error: excepion caught : " << e.what() << endl;
  return 1;
}

