#ifndef _SYNT_OUTPUT_H_
#define _SYNT_OUTPUT_H_

#include <string>
#include <set>

#include <outilex/xml.h>

struct synt_output {

  //static const synt_output _zero = synt_output(true);
  //static const synt_output _one  = synt_output(false);

  struct elem {

    int pos; 
    std::string v;

    inline elem(xmlNodePtr node) { read_XML(node); }

    inline elem(const std::string & _v) : v(_v) {
      if (v.find('$') != std::string::npos) {
        pos = 0;
      } else { pos = -1; }
    }
 
    inline elem delay() const {
      if (pos == -1) { return *this; }
      return elem(v, pos + 1);
    }
    
    inline void operator++() { if (pos >= 0) { pos++; } }

    bool operator<(const elem & b) const {
      if (pos != b.pos) { return pos < b.pos; }
      return v < b.v;
    }

    static inline const xmlChar * xml_name() { return (const xmlChar *) "e"; }
    void read_XML(xmlNodePtr node);
    void write_XML(xmlwriter & writer) const;

    void dump_text(std::ostream & os) const;
 
  protected:
    elem(const std::string & v_, int pos_) : v(v_), pos(pos_) {}
  };

  bool inf;
  std::set<elem> v;

  // default constructor return one()
  inline synt_output(bool _inf = false) : inf(_inf), v() {}
  inline synt_output(xmlNodePtr node) { read_XML(node); }

  /* delay the output, increment pos by one to keep track of the position
   * of the matching (word|syntagm) in the matching sequence
   */

  synt_output delay() const;

  // mult: concat: union
  static synt_output mult(const synt_output & a, const synt_output & b);
  // plus: prefix: intersection
  static synt_output plus(const synt_output & a, const synt_output & b);
  // minus: (plus^-1) suffix: difference
  static synt_output minus(const synt_output & a, const synt_output & b);

  // zero: inf ensemble de tous les elements
  static inline synt_output zero() { return synt_output(true); }
  // one: ensemble vide
  static inline synt_output one()  { return synt_output(false); }

  inline bool operator<(const synt_output & b) const {
    if (inf) {
      if (b.inf) {
        return false;
      } else { return true; }
    }
    if (b.inf) { return false; }
    return v < b.v;
  }


  static inline const xmlChar * xml_name() { return (const xmlChar *) "synt_output"; }
  void read_XML(xmlNodePtr node);
  void write_XML(xmlwriter & writer) const;

  void read_text(const std::string & text); // read from hand-written grammar
  void dump_text(std::ostream & os) const;
};



inline bool operator!=(const synt_output & a, const synt_output & b) {
  return (a < b) || (b < a);
}

inline std::ostream & operator<<(std::ostream & os, const synt_output & o) {
  o.dump_text(os); return os;
}


#endif

