#include <iostream>
#include <stack>

#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/fstream.hpp>
#include <boost/filesystem/convenience.hpp>
                       
#include <outilex/lingdef.h>
#include <outilex/grammar.h>

using namespace std;

namespace fs = boost::filesystem;


char * progname;


void usage() {
  cerr << "usage: " << progname << " -l <lingdef> [-o <output> ] <grammar>\n";
  exit(1);
}


int main(int argc, char ** argv) try {

  string grammarname, lingdefname, outputname;
  bool validate = false;

  progname = *argv;

  argv++, argc--;

  while (argc) {
    
    string arg = *argv;
    
    if (arg == "-l") {
      
      argv++, argc--;
      if (argc == 0) { usage(); }
      lingdefname = *argv;
    
    } else if (arg == "-o") {
      
      argv++, argc--;
      if (argc == 0) { usage(); }
      outputname = *argv;

    } else if (arg == "-h") {
    
      usage();
    
    } else {
      grammarname = arg;
    }

    argv++, argc--;
  }

  if (grammarname.empty() || lingdefname.empty()) { usage(); }

  ling_def * lingdef = new ling_def(lingdefname);

  fs::path path(grammarname);

  cerr << "loading " << path.native_file_string() << endl;

  grammar gram(path, lingdef);

  cerr << "grammar loaded\n";

  if (outputname.empty()) {
    xmlwriter writer(cout);
    gram.write_XML(writer);
  } else { gram.write(outputname); }


  cerr << "done.\n";

} catch (exception & e) {

  cerr << "error: excepion caught : " << e.what() << endl;
  return 1;
}

