#include <iostream>
#include <outilex/rtn_transduct.h>
#include <outilex/rtn_parser.h>

#include <outilex/sentence_fsa.h>

using namespace std;

namespace {


void output_match_tree(const sentence_fsa & text, const rtn_match & match,
                       const rtn_chart & chart, ostream & os) {

  os << "(" << match.name << ' ';

  int size = match.path.size();

  for (int i = 0; i < size; ++i) {
    const syntref & ref = match.path[i];
    if (ref.transno < 0) {
      output_match_tree(text, chart[ref.qno][- ref.transno - 1], chart, os);
      os << ' ';
    } else {
      //os << 'x' << text.get_trans(ref.qno, ref.transno).in() << 'x' << ' ';
      os << text.get_trans(ref.qno, ref.transno).in().form << ' ';
    }
  }

  os << " " << match.name << ")";
}

void dump_all_matches(const sentence_fsa & text, const rtn_chart & chart,
                      const string & syntname, ostream & os) {

  os << "dump all matches :\n";

  for (int q = 0; q < text.size(); ++q) {
    os << q << ":\n";
    for (rtn_chart::const_match_iterator it = chart[q].begin();
         it != chart[q].end(); ++it) {
      if (it->name == syntname) {
        output_match_tree(text, *it, chart, os);
        os << '\n';
      }
    }
  }
}


void output_match(const sentence_fsa & text, const rtn_match & match,
                  const rtn_chart & chart, ostream & os,
                  trans_mode_type transmode, trans_output_type outmode) {

  if (outmode == HTML) { os << "<strong>"; }


  //output_match_tree(text, match, chart, os);

  int size = match.path.size();
  int i = 0;
  for (i = 0; i < size; ++i) {
    
    const syntref & ref = match.path[i];
    
    if (! match.out[i].empty()) { os << match.out[i] << ' '; }
 
    if (ref.transno < 0) {
      output_match(text, chart[ref.qno][- ref.transno - 1], chart, os, transmode, outmode);
    } else {
      os << text.get_trans(ref.qno, ref.transno).in().form << ' ';
    }
  }

  if (! match.out[i].empty()) { os << match.out[i] << ' '; }
  if (outmode == HTML) { os << "</strong>"; }
}

void output_trans(const sentence_fsa::transition & tr, ostream & os,
                  trans_mode_type transmode, trans_output_type outmode) {
  os << tr.in().form << ' ';
}


struct compare_dest {
  template<typename Trans>
  bool operator()(const Trans & a, const Trans & b) {
    return a.to() < b.to();
  }
};


rtn_chart::const_match_iterator find_better_match(const string & syntname, 
                                                  const unique_sequence<rtn_match> & tab) {

  rtn_chart::const_match_iterator res = tab.end();
  int to = -1;

  for (rtn_chart::const_match_iterator it = tab.begin(), end = tab.end();
       it != end; ++it) {
    if (it->to > to && it->name == syntname) {
      res = it; to = it->to;
    }
  }
  return res;
}


}; // namespace ""

int rtn_transduct(const sentence_fsa & text, rtn_parser & parser,
                  ostream & os, trans_mode_type transmode, trans_output_type outmode) {

  //  cerr << "\n\ntransduct new sentence\n";
  //  cerr << text.text << "\n\n";

  if (text.empty()) {
    cerr << "warning: empty sentence\n";
    return 0;
  }

  rtn_chart chart(text);
  parser.parse(text, chart, true);
  
  int nbmatches = 0;
  const string & syntname = parser.gram.start_name();

  //dump_all_matches(text, chart, syntname, cerr);

  int q = 0;
  while (! text.final(q)) {
    
    rtn_chart::const_match_iterator m = find_better_match(syntname, chart[q]);

    if (m != chart[q].end()) { // find a match

      ++nbmatches;

      output_match(text, *m, chart, os, transmode, outmode);
      q = m->to;

    } else { // output a transition

#warning : todo output lex transition

      sentence_fsa::const_trans_iterator tr = min_element(text.trans_begin(q),
                                                          text.trans_end(q),
                                                          compare_dest());
    
      if (tr == text.trans_end(q)) {
        os << "*error*";
        cerr << "error: bad text automaton\n";
        goto out;
      }
      output_trans(*tr, os, transmode, outmode);
      q = tr->to();
    }
  }

out:
  os << "\n";
  if (outmode == HTML) {
    os << "<br/>\n";
  }
  return nbmatches; 
}

