#ifndef _RTN_PATTERN_H_
#define _RTN_PATTERN_H_

#include <string>
#include <boost/filesystem/path.hpp>

#include <outilex/basic_fst.h>
#include <outilex/rtn_input_type.h>

class ling_def;
class generic_fst;

class rtn_pattern : public basic_fst<rtn_input_type, std::string> {

public:

  typedef basic_fst<rtn_input_type, std::string> fst_type;


  rtn_pattern() : fst_type(), lingdef(0) {}
  rtn_pattern(ling_def * ldef) : fst_type(), lingdef(ldef) {}

  rtn_pattern(const generic_fst & fst, ling_def * ldef);

  rtn_pattern(const boost::filesystem::path & path, ling_def * ldef);

  const std::string & get_name() const { return name; }

  void write(const boost::filesystem::path & path) const;
  void read(const boost::filesystem::path & path, ling_def * ldef);

  void read_xml(xmlNode * node, ling_def * ldef);
  void write_xml(xmlwriter & writer) const;

public:
  ling_def * lingdef;
  std::string name;
};


#endif
