#ifndef _RTN_PARSER_H_
#define _RTN_PARSER_H_

#include <vector>
#include <set>

#include <outilex/syntref.h>

#include <boost/iterator/indirect_iterator.hpp>

#include <outilex/rtn_grammar.h>
#include <outilex/sentence_fsa.h>

#include <outilex/unique_sequence.h>


/* EARLEY parser for RTN local grammars */


struct rtn_match {

  rtn_match(const std::string & n, int t, const synt_path_type & p,
            const std::vector<std::string> & o)
    : name(n), to(t), path(p), out(o) {}

  bool operator<(const rtn_match & b) const { // sort by length first
    if (to != b.to) { return to < b.to; }
    if (name != b.name) { return name < b.name; }
    if (path != b.path) { return path < b.path; }
    return out < b.out;
  }

  std::string name;
  int to;
  synt_path_type path;
  std::vector<std::string> out;
};

#if 0
struct rtn_chart {

  rtn_chart(const sentence_fsa & fsa) : tab(fsa.size()) {}

  std::vector<rtn_match> & operator[](int q) { return tab[q]; }
  const std::vector<rtn_match> & operator[](int q) const { return tab[q]; }

  int add_match(int q, const rtn_match & match) {
    tab[q].push_back(match);
    return tab[q].size() - 1;
  }
 
  std::vector<std::vector<rtn_match> > tab;

  typedef std::vector<rtn_match>::iterator match_iterator;
  typedef std::vector<rtn_match>::const_iterator const_match_iterator;
};
#endif

struct rtn_chart {

  rtn_chart(const sentence_fsa & fsa) : tab(fsa.size()) {}

  unique_sequence<rtn_match> & operator[](int q) { return tab[q]; }
  const unique_sequence<rtn_match> & operator[](int q) const { return tab[q]; }

  int add_match(int q, const rtn_match & match) {
    return tab[q].add(match); // -1 if already here
  }
 
  std::vector<unique_sequence<rtn_match> > tab;

  typedef unique_sequence<rtn_match>::iterator match_iterator;
  typedef unique_sequence<rtn_match>::const_iterator const_match_iterator;
};


class rtn_parser {

public:

  typedef rtn_grammar::input_type  input_type;
  typedef rtn_grammar::output_type output_type;


  rtn_parser(const rtn_grammar & grm) : gram(grm), pchart(NULL), agenda() {}
  ~rtn_parser() {}


  void parse(const sentence_fsa & fsa, rtn_chart & res, bool surf = false);


public:

  /* internal data structures */

  struct e_item {

    const rtn_pattern * pfst;
    int q;
    int from, to;
    std::vector<std::string> out;
    synt_path_type path;

    e_item(const rtn_pattern & fst_, int q_, int from_, int to_,
           const std::vector<std::string> & out_, const synt_path_type & path_)
      : pfst(& fst_), q(q_), from(from_), to(to_), out(out_), path(path_) {}


    bool operator<(const e_item & item) const {
      if (pfst != item.pfst) { return pfst < item.pfst; }
      if (q != item.q) { return q < item.q; }
      if (from != item.from) { return from < item.from; }
      if (to != item.to) { return to < item.to; }
      return false;
      //if (out != item.out) { return out < item.out; }
      //return path < item.path;
    }

    void dump(std::ostream & os) const;
  };


  typedef unique_sequence<e_item> earley_stack;

#if 0
  struct earley_stack {
  
    typedef std::set<e_item> item_set;
    typedef std::vector<item_set::iterator> item_vec;

    typedef boost::indirect_iterator<item_vec::iterator> iterator;

    earley_stack() : items(), tab() {}

    int size() const { return tab.size(); }

    const e_item & operator[](int idx) const { return *(tab[idx]); }

    iterator begin() { return iterator(tab.begin()); }
    iterator end() { return iterator(tab.end()); }

    void add(const e_item & item) {
      pair<item_set::iterator, bool> p = items.insert(item);
      if (p.second == false) { return; } // already here
      tab.push_back(p.first);
    }

    item_set items;
    item_vec tab;
  };
#endif

  typedef std::vector<earley_stack> e_agenda;

  const rtn_grammar & gram;
  rtn_chart * pchart;
  const sentence_fsa * ptxt;
  e_agenda agenda;

protected:

  void ENQUEUE(int pos, const e_item & item);
  void PREDICTOR(int pos, const std::string & syntname);
  void COMPLETER(int pos, const e_item & item);
};

inline std::ostream & operator<<(std::ostream & os, const rtn_parser::e_item & item) {
  item.dump(os); return os;
}
#endif
