#include <iostream>
#include <string>
#include <outilex/xml_format_lexmask.h>
#include <outilex/xml.h>
#include <outilex/xml-names.h>

#include <outilex/lexical_mask.h>

using namespace std;
using namespace xmlnames;

class lingdef;


void lexmask_read_xml(xmlNode * node, lexical_mask & m, ling_def * ldef) {
  if (xmlStrcmp(node->name, LEXMASK_ELEM)) {
    throw runtime_error("lexmask_read_xml: bad node type: "
                        + string((const char *) node->name));
  }
  m.read_XML(node, ldef);
}

void lexmask_write_xml(xmlwriter & writer, const lexical_mask & m) {
  m.write_XML(writer);
}

void lexical_mask::read_XML(xmlNodePtr node, ling_def * lingdef) {

  if (node == 0) { clear(); return; }

  unspec();
  node = node->xmlChildrenNode;

  char * text;

  while (node) {

    if (xmlStrcmp(node->name, FORM_ELEM) == 0) {
    
      form.read_XML(node);
    
    } else if (xmlStrcmp(node->name, LEMMA_ELEM) == 0) {
    
      lemma.read_XML(node);
    
    } else if (xmlStrcmp(node->name, POS_ELEM) == 0) {

      text = xmlGetProp(node, VAL_ATTR);
      string posname(text);
      xmlFree(text);
      
      pos = lingdef->get_pos(posname);

      if (pos == NULL) {
        if (unknow_attributes.find(posname) == unknow_attributes.end()) {
          cerr << "lexmask: unknow POS : " << posname << "\n";
          unknow_attributes.insert(posname);
        }
        clear();
        return;
      }

    } else if (xmlStrcmp(node->name, FEAT_ELEM) == 0) {
 
      if (pos == pos_unspec) {
        throw xml_parse_error("lexmask: featset with no POS specified?");
      }
 
      if ((text = xmlGetConstProp(node, NAME_ATTR)) == 0) {
        throw xml_parse_error("lexical_mask::read_XML: invalid featset element");
      }
 
      attr_def * attr = pos->get_attr(text);
      if (! attr) {
        if (unknow_attributes.find(text) == unknow_attributes.end()) {
          unknow_attributes.insert(text);
          cerr << "lexmask::read_xml: unknow attribute " << text << " (in POS " << pos->get_name() << ")\n";
        }
        goto next;
      }

      if ((text = xmlGetConstProp(node, VAL_ATTR)) == 0) {
        throw xml_parse_error("lexical_mask::read_XML: invalid featset element");
      }

      try {

        feat_set fs(attr->get_type(), text);
        feats[attr] = fs;

      } catch (exception & e) {

        if (unknow_attributes.find(text) == unknow_attributes.end()) {
          cerr << "error with feat (" << attr->get_name() << ", " << text << ") : " << e.what() << "\n";
          unknow_attributes.insert(text);
        }
      }
    }

next:
    node = node->next;
  }
}

void lexical_mask::write_XML(xmlwriter & writer) const {


  writer.start_element(LEXMASK_ELEM);

  if (empty()) {

    writer.write_element(VOID_ELEM);

  } else {

    if (! form.is_unspec())  { form.write_XML(writer, FORM_ELEM); }
    if (! lemma.is_unspec()) { lemma.write_XML(writer, LEMMA_ELEM); }

    if (pos != pos_unspec) {
      writer.start_element(POS_ELEM);
      writer.write_attribute(VAL_ATTR, pos->get_name());
      writer.end_element();

      for (feats_map::const_iterator it = feats.begin(); it != feats.end(); ++it) {
        writer.start_element(FEAT_ELEM);
        writer.write_attribute(NAME_ATTR, it->first->get_name());
        writer.write_attribute(VAL_ATTR, it->second.get_val_text());
        writer.end_element();
      }
    }
  }
  writer.end_element();
}

