#include <iostream>
#include <list>
#include <map>

#include <boost/filesystem/path.hpp>
#include <boost/assign/list_inserter.hpp>

#include <outilex/lingdef.h>
#include <outilex/lexical_mask.h>

using namespace std;
using namespace boost::assign;
namespace fs = boost::filesystem;


char * progname;

void usage() {
  cout << "usage: " << progname << "[<lingdef>]\n";
  exit(0);
}


typedef void (*operation_f)(const lexical_mask & a, const lexical_mask & b);


void op_in(const lexical_mask & a, const lexical_mask & b) {
  cout << a << " in " << b << " = " << a.in(b) << endl;
}

void op_intersect(const lexical_mask & a, const lexical_mask & b) {
  cout << a << " intersects " << b << " = " << a.intersects(b) << endl;
}

void op_inter(const lexical_mask & a, const lexical_mask & b) {
  lexical_mask m(a);
  m &= b;
  cout << a << " inter " << b << " = " << m << endl;
}

void op_minus(const lexical_mask & a, const lexical_mask & b) {
#if 0
  list<lexical_mask> res;
  lexical_mask::minus(a, b, back_inserter(res));
  cout << a << " minus " << b << " =  { ";
  copy(res.begin(), res.end(), ostream_iterator<lexical_mask>(cout, ", "));
  cout << "}\n";
#endif
  cerr << "lexmask difference is no more implemented\n";
}

void op_equal(const lexical_mask & a, const lexical_mask & b) {
  cout << a << " == " << b << " = " << (a == b) << endl;
}

void op_nequal(const lexical_mask & a, const lexical_mask & b) {
  cout << a << " != " << b << " = " << (a == b) << endl;
}


int main(int argc, char ** argv) try {


  map<string, operation_f> operations;
  insert(operations)
    ("in", op_in)
    ("intersect", op_intersect)
    ("inter", op_inter)
    ("minus", op_minus)
    ("==", op_equal)
    ("!=", op_nequal)
    ;

  fs::path lingdefpath;

  char * text = getenv("LINGDEF");
  if (text) {
    lingdefpath = fs::path(text);
  }

  progname = *argv;

  argv++, argc--;
  while (argc) {
    string arg = *argv;
    if (arg == "-h") { 
      usage();
    } else {
      lingdefpath = fs::path(arg);
    }
    
    argv++, argc--;
  }

  if (lingdefpath.empty()) {
    cerr << "no lingdef specified\n";
    exit(1);
  }

  ling_def lingdef(lingdefpath);

  string line;
  while (getline(cin, line)) {

    istringstream iss(line);

    try {

      string m1, op, m2;
 
      if (! (iss >> m1)) {
        continue;
      }

      lexical_mask a(m1, & lingdef);

      if (! (iss >> op)) {
        cout << a << endl;
        continue;
      }

      iss >> m2;
      lexical_mask b(m2, & lingdef);

      if (operations.find(op) == operations.end()) {
        cerr << "unknow operation : " << op << endl;
        continue;
      }

      operations[op](a, b);
 
    } catch (exception & e) {
      cerr << "error : " << e.what() << endl;
    }
  }

} catch (exception & e) {
  cerr << "fatal error : " << e.what() << endl;
  exit(1);
}

