#ifndef _LEXICAL_MASK_H_
#define _LEXICAL_MASK_H_

#include <tr1/functional>
#include <outilex/feat_set.h>

class ling_def;
class lexical_entry;
class dic_lex_entry;


/* a lexical mask describe the set of lexical entries which match with
 * the set of specified features
 */

class lexical_mask {

public: // make all data members public

#if 0
  form_set form;
  form_set lemma;
#endif

  std::string form;
  std::string case_fold; // case independant form representation
  std::string lemma;

  // -1 means unspecified, 0 means that this mask is void, i.e. it descibes empty set
  const pos_def * pos;

  typedef std::map<attr_def *, feat_set> feats_map;
  mutable feats_map feats; // creation of unspec feature do not modify constness


public:

  /* default constructor, matches with the whole lexic
   */
  lexical_mask(pos_def * pos_ = pos_unspec) : form(), case_fold(), lemma(), pos(pos_), feats() {}

  /* construct from an xml description */
  lexical_mask(xmlNodePtr node, ling_def * lingdef)
    : form(), case_fold(), lemma(), pos(pos_unspec), feats() { read_XML(node, lingdef); }

  /* construct from a text description */
  lexical_mask(const std::string & txt, ling_def * lingdef)
    : form(), case_fold(), lemma(), pos(pos_unspec), feats() { read_text(txt, lingdef); }

  /* construct from a dic_lex_entry */
  lexical_mask(const dic_lex_entry & e, ling_def * lingdef);



  const pos_def * get_pos() const { return pos; }

  /* return true if mask describe nothing (empty set)
   * false otherwise
   */

  bool empty() const { return pos == 0; }
  /*
  bool empty() const {
    if (pos == 0) { return true; }
    if ((! form) || (! lemma)) { pos = 0; return true; }

    for (feats_map::const_iterator it = feats.begin(); it != feats.end(); ++it) {
      if (! (*it).second) {
        feats.clear(); pos = 0; return true;
      }
    }
    return false;
  }
  */
  
  /* clear mask, and make it describe empty set */
  
  void clear() { form.clear(); case_fold.clear(); lemma.clear(); feats.clear(); pos = 0; }

  /* make the mask describe all the lexic */

  void unspec() { form.clear(); case_fold.clear(); lemma.clear(); feats.clear(); pos = pos_unspec; }
 


  /* get/set a feat_set for a given attr_def */

  const feat_set & operator[](attr_def * attr) const;
  feat_set & operator[](attr_def * attr);
 
  const feat_set & operator[](const std::string & attrname) const;
  feat_set & operator[](const std::string & attrname);
 

#if 0
  /* int assignement operator
   * m = 0 -> mask is void (match with nothing)
   * m = 1 (!= 0) -> mask match everything
   */

  lexical_mask & operator=(int v) {
    if (v == 0) {
      clear();
    } else { unspec(); }
    return * this;
  }
#endif

  /* int cast operator
   * return 1 if mask match with something (theoretically)
   *        0 otherwise
   */

  operator const void*() const { return empty() ? 0 : this; }

  bool operator!() const { return empty(); }


  /* ensemblist operations */

  /* return true if *this is included in m
   */
  bool in(const lexical_mask & m) const;


  /* return true if the two masks are not disjoint */
  bool intersects(const lexical_mask & m) const;


  /* assign to *this the intersection of a and b
   * return true if result is not empty
   */

  bool set_inter(const lexical_mask & a, const lexical_mask & b);
  
  /* assign to *this the intersection of *this and b */
  void set_inter(const lexical_mask & b);
  void operator&=(const lexical_mask & b) { set_inter(b); }


#if 0
  /* return true if e is included in the set described by the mask */
  bool match(const lexical_entry & e) const;
  static bool match(const lexical_entry & e, const lexical_mask & m) { return m.match(e); }
#endif

  bool match(const lexical_mask & e) const { return intersects(e); }
  static bool match(const lexical_mask & e, const lexical_mask & m) { return m.intersects(e); }



  /* serialisation functions */

  void read_XML(xmlNodePtr node, ling_def * lingdef);
  void write_XML(xmlwriter & writer) const;

  void read_text(const std::string & txt, ling_def * lingdef);
  void dump_text(std::ostream & os) const;
};


/* compare to lexical_mask (no order) */
#if 0
bool operator==(const lexical_mask & a, const lexical_mask & b);
inline bool operator!=(const lexical_mask & a, const lexical_mask & b) { return ! (a == b); }
#endif

inline std::ostream & operator<<(std::ostream & os, const lexical_mask & m) {
  m.dump_text(os); return os;
}


#if 0
namespace std {
namespace tr1 {

template<>
struct hash<lexical_mask>
  : public std::unary_function<lexical_mask, std::size_t> {

  std::size_t operator()(const lexical_mask & m) {
    std::ostringstream oss;
    oss << m;
    return hash<std::string>()(oss.str());
  }
};

}; //tr1
}; //std
#endif

#endif

#if 0
  template<class OutputIterator>
  static void minus(const lexical_mask & a, const lexical_mask & b, OutputIterator out) {

//    std::cerr << "lexmask: " << a << " minus " << b << std::endl;

    if (! b.in(a)) { // first, make sure that b is included in a
      lexical_mask bb;
      bb.set_inter(a, b);
      minus(a, bb, out);
      return;
    }

    if (a.empty()) { // a is empty, return empty set
      return;
    }

    if (b.empty()) { // b is empty, return a
      *out = a; ++out;
      return;
    }

    lexical_mask m(a);


    if (b.pos != pos_unspec) {

      if (m.pos == pos_unspec) {

        std::vector<const pos_def *> poss;
        ::minus(m.pos, b.pos, back_inserter(poss));

        for (std::vector<const pos_def *>::const_iterator it = poss.begin();
             it != poss.end(); ++it) {
          m.pos = *it;
          *out = m; ++out;
        }

        m.pos = b.pos;
      }

      for (feats_map::const_iterator itb = b.feats.begin(); itb != b.feats.end(); ++itb) {

        attr_def * attr  = (*itb).first;
        const feat_set & featb = (*itb).second;

        feats_map::iterator itm = m.feats.find(attr);

        if (itm == m.feats.end()) {  // add unspec featset if attribute not specified in a
          itm = m.feats.insert(m.feats.begin(), std::make_pair(attr, feat_set(attr->get_type())));
        }

        feat_set & featm = (*itm).second;
        featm -= featb;

        if (featm) {
          *out = m; ++out;
        }
        featm = featb;
      }
    } else { assert(m.pos == pos_unspec); }

    // compute form at the end

    m.form -= b.form;
    if (m.form) { // b form is a strict subset of a form
      *out = m; ++out;
    }
    m.form = b.form;

    m.lemma -= b.lemma;
    if (m.lemma) {
      *out = m; ++out;
    }
    //m.lemma = b.lemma;
  }
#endif
#if 0
template<class OutputIterator>
void minus(const lexical_mask & a, const lexical_mask & b, OutputIterator out) {
  lexical_mask::minus(a, b, out);
}
#endif
