#ifndef _LEXICAL_ENTRY_H_
#define _LEXICAL_ENTRY_H_

#include <iostream>
#include <string>
#include <vector>


#include <outilex/xml.h>

class ling_def;
class pos_def;

class lexical_entry {

public:
  std::string form;
  std::string lemma;
  pos_def * pos;
  std::vector<int> feats;

  lexical_entry() : form(), lemma(), pos(NULL), feats() {}

  void clear() { form.clear(); lemma.clear(); pos = NULL; feats.clear(); }


  void write_XML(xmlwriter & writer) const;
  void read_XML(xmlNodePtr node, ling_def * lingdef);

  void read_text(const std::string & text, ling_def * lingdef);
  void dump_text(std::ostream & os) const;
};


inline bool operator<(const lexical_entry & a, const lexical_entry & b) {
  if (a.pos != b.pos) { return a.pos < b.pos; }
  if (a.lemma != b.lemma) { return a.lemma < b.lemma; }
  if (a.form != b.form) { return a.form < b.form; }
  return a.feats < b.feats;
}


inline std::ostream & operator<<(std::ostream & os, const lexical_entry & e) {
  e.dump_text(os); return os;
}

#endif

