#ifndef _FORM_SET_H_
#define _FORM_SET_H_


#include <list>
#include <string>

#include <outilex/xml.h>

/* represent a set of strings,
 * if negative represents the set of all string which are not present in vals
 * default constructor set neg to true and vals to empty set, so that the set matchs
 * with 'any string'
 */

class form_set {

  bool neg;
  std::list<std::string> vals;

public:

  form_set() : neg(true), vals() {}


  /* assign the set to { form }
   */

  form_set & operator=(const std::string & form) {
    neg = false; vals.clear(); vals.push_back(form); return *this;
  }


  /* add form to the set
   */
  
  form_set & operator+=(const std::string & form);


  /* int cast operator */
  operator const void*() const { return empty() ? 0 : this; }

  bool operator!() const { return empty(); }


  /* comparaison operators */

  bool operator==(const form_set & b) const {
    if (neg != b.neg) { return false; }
    return vals == b.vals;
  }

  bool operator!=(const form_set & b) const {
    return ! (*this == b);
  }

  /* clear the set, make it recognize no string */

  void clear() { vals.clear(); neg = false; }

  /* make the set recognize every string */

  void unspec() { vals.clear(); neg = true; }

  bool empty() const { return (! neg) && vals.empty(); }
  bool is_unspec() const { return neg && vals.empty(); }


#if 0
  /* int assignement operator
   */

  form_set & operator=(int v) {
    if (v == 0) { // empty set
      clear();
    } else {
      unspec();
    }
    return *this;
  }
#endif

  /* is a a subset of b ? */

  static bool in(const form_set & a, const form_set & b);

  bool intersects(const form_set & b) const;


  /* set form_set to the intersection of a and b */

  bool set_inter(const form_set & a, const form_set & b);
  void set_inter(const form_set & b);

  void operator&=(const form_set & b) { set_inter(b); }

  bool set_minus(const form_set & a, const form_set & b);
  void set_minus(const form_set & b);

  void operator-=(const form_set & b) { set_minus(b); }


  /* return true if form is described in this form_set */

  bool match(const std::string & form) const {
    std::list<std::string>::const_iterator it = std::lower_bound(vals.begin(), vals.end(), form);
    if (neg) {
      return it == vals.end() || *it != form;
    } else { return it != vals.end() && *it == form; }
  }


  /* serialisation */

  void read_xml(xmlNodePtr node);
  void write_xml(xmlwriter & os, const std::string & name) const;

  void dump_text(std::ostream & os) const;
  void read_text(const std::string & text);

  void dump_unescaped(std::ostream & os) const;
};

inline std::ostream & operator<<(std::ostream & os, const form_set & form) {
  form.dump_text(os); return os;
}

inline form_set & form_set::operator+=(const std::string & form) {

  std::list<std::string>::iterator it = std::lower_bound(vals.begin(), vals.end(), form);

  if (neg) {
    if (it != vals.end() && *it == form) {
      vals.erase(it);
    }
  } else {
    if (it == vals.end() || *it != form) {
      vals.insert(it, form);
    }
  }
  return *this;
}


#if 0

/* return true if a is a subset of b */

inline bool in(const form_set & a, const form_set & b) {
  return form_set::in(a, b);
}


inline bool match(const std::string & f, const form_set & s) { return s.match(f); }

inline bool inter(const form_set & a, const form_set & b, form_set & res) {
  return res.set_inter(a, b);
}


inline bool minus(const form_set & a, const form_set & b, form_set & res) {
  return res.set_minus(a, b);
}


inline std::ostream & operator<<(std::ostream & os, const form_set & fs) {
  fs.dump_unescaped(os); return os;
}
#endif

#endif

