#ifndef _BOOL_ATTR_H_
#define _BOOL_ATTR_H_


#include <outilex/lingdef.h>
#include <outilex/attr_type.h>

#include <outilex/enum_attr.h>



class bool_attr_type : public enum_attr_type {

  static const int VALUE_UNSET = 0;
  static const int VALUE_TRUE  = 1;
  static const int VALUE_FALSE = 2;

  std::string shortcut[3];

  void init_standard_values();
  void read_XML(xmlNodePtr node);

public:

  bool_attr_type(const std::string & type_name);
  bool_attr_type(xmlNodePtr node);

  void register_shortcut_values(attr_def * attr, pos_def * pos);

  void dump_feat_val(const std::string & attrname, int val, bool shortcut, std::ostream & os) const;

  void dump_feat_val_set(const std::string & attrname, const attr_val_set * vs,
                         bool shortcut, std::ostream & os) const;
};


#endif

