#ifndef _ATTR_TYPE_H_
#define _ATTR_TYPE_H_


#include <string>
#include <outilex/xml.h>



/* class to represent a type of an attribute
 */


/* represent an ensemble of values for a given attribute
 * virtual class also, specialised in each attribute type implementation
 */

class attr_val_set {
public:
  virtual ~attr_val_set() {}
};


/* attribute type.
 * pure virtual class, 
 * functionnalities are implemented
 * in derived classes like enum_attr_type, tree_attr_type, bool_attr_type, ref_attr_type ...
 */

class attr_def;
class pos_def;

class attr_type {

public:

  virtual ~attr_type() {}

  virtual const std::string & get_name() const = 0;

  /* create an unspec val set (matches with all value including 'unset') */
  virtual attr_val_set * new_val_set() = 0;

  /* create an val set containing only the value specified, 
   * special value -1 means everything but unset
   * (value 0 always means 'unset')
   */
  virtual attr_val_set * new_val_set(int val) =0;

  /* create an val set copy of the specified val set */
  virtual attr_val_set * new_val_set(const attr_val_set * vs) = 0;
  
  /* create a val set from a textual description */
  virtual attr_val_set * new_val_set(const std::string & str) = 0;

  virtual void del_val_set(attr_val_set * vs) = 0;

  virtual void copy_val_set(attr_val_set *& dest, const attr_val_set * src) = 0;


  virtual bool is_val_set_empty(const attr_val_set * vs) = 0;
  virtual bool is_val_set_unspec(const attr_val_set * vs) = 0;

  //virtual bool less_than(attr_val_set * a, attr_val_set * b) = 0;

  virtual void clear_val_set(attr_val_set *& vs) = 0; // vs match with nothing
  virtual void unset_val_set(attr_val_set *& vs) = 0; // vs match with unset
  virtual void set_val_set(attr_val_set *& vs)   = 0; // vs match with all but unset (== unspec)

  virtual bool in(const attr_val_set * a, const attr_val_set * b) = 0;
  virtual bool intersects(const attr_val_set * a, const attr_val_set * b) = 0;

  virtual attr_val_set * inter(const attr_val_set * a, const attr_val_set * b) = 0;
  virtual attr_val_set * union_(const attr_val_set * a, const attr_val_set * b) = 0;
  virtual attr_val_set * minus(const attr_val_set * a, const attr_val_set * b) = 0;

  virtual bool equal(const attr_val_set * a, const attr_val_set * b) = 0;

  virtual bool match(int v, const attr_val_set * vs) = 0;


  virtual void register_shortcut_values(attr_def * attr, pos_def * pos) {}

  virtual int get_value(const std::string & txt) const = 0;


  virtual void dump_val_set_text(const attr_val_set * vs, std::ostream & os) const = 0;
  virtual std::string get_val_set_text(const attr_val_set *vs) const;

  virtual void dump_val_text(int val, std::ostream & os) const = 0;
  virtual std::string get_val_text(int val) const;

  virtual void dump_feat_val(const std::string & attrname, int val,
                             bool shortcut, std::ostream & os) const {
    os << '+' << attrname << '=';  dump_val_text(val, os);
  }

  virtual void dump_feat_val_set(const std::string & attrname, const attr_val_set * vs,
                                 bool shortcut, std::ostream & os) const {
    os << '+' << attrname << '='; dump_val_set_text(vs, os);
  }
};


extern attr_type * void_attribute_type;


typedef attr_type * (*attr_type_loader_f)(xmlNodePtr node);


/*
 * allow registering a new type loader
 */

class attr_type_registerer {
public:
  attr_type_registerer(const std::string & attr_type_name, attr_type_loader_f loader);
};


/* attribute type loader,
 * given a type name (and its XML description), construct and return the right object
 */

attr_type * new_attr_type(const std::string & attr_typename, xmlNodePtr node);

#endif

