#include <outilex/lexical_mask2.h>
#include <outilex/lexical_mask.h>


using namespace std;


lexical_mask2::lexical_mask2(const lexical_mask & m) 
  :form(), lemma(), pos(m.pos), feats(m.feats) {
    
    if (! m.case_fold.empty()) { form = m.case_fold; }
    if (! m.lemma.empty()) { lemma = m.lemma; }
}


bool lexical_mask2::operator==(const lexical_mask2 & b) const {

  if (this == & b) { return true; }

  if (! *this && ! b) { return true; }

  if (pos != b.pos) { return false; }

  if (form != b.form) { return false; }

  if (lemma != b.lemma) { return false; }

  if (feats.size() != b.feats.size()) { return false; }

  return feats == b.feats;
}


bool lexical_mask2::set_inter(const lexical_mask2 & a, const lexical_mask2 & b) {

  if (& a == this) { lexical_mask2 aa = a; return set_inter(aa, b); }
  if (& b == this) { lexical_mask2 bb = b; return set_inter(a, bb); }

  if (! a || ! b) { // if one mask is empty return the empty set
    clear(); return false;
  }

  pos = inter(a.pos, b.pos);

  if (pos == 0) { // incompatible POSs
    clear(); return false;
  }

  form.set_inter(a.form, b.form);
  if (! form) { clear(); return false; }

  lemma.set_inter(a.lemma, b.lemma);
  if (! lemma) { clear(); return false; }


  if (pos != pos_unspec) {

    if (a.pos == pos_unspec) {

      feats = b.feats;

    } else if (b.pos == pos_unspec) {

      feats = a.feats;

    } else { // a.pos == b.pos (!= pos_unspec) : compute feats intersection

      feats = a.feats;
      feats_map::iterator ita, itb;

      for (itb = b.feats.begin(); itb != b.feats.end(); ++itb) {

        attr_def * attr = (*itb).first;
 
        ita = feats.find(attr);

        if (ita == feats.end()) { // attr not specified in a

          feats.insert(*itb);

        } else { // attr specified in a and b, compute intersection

          feat_set & fs = ita->second;
          fs &= itb->second; // intersect feat_set

          if (! fs) { // empty intersection -> masks are not compatible
            clear(); return false;
          }
        }
      }
    }

  } else { feats.clear(); }

  return true; 
}


void lexical_mask2::set_inter(const lexical_mask2 & b) {

  if (empty() || ! b) { // if one mask is empty return the empty set
    clear(); return;
  }

  const pos_def * npos = inter(pos, b.pos);

  if (npos == 0) { // incompatible POSs
    clear(); return;
  }

  form &= b.form;
  if (! form) { /*cerr << "! inter form\n"; */ clear(); return; }

  lemma &= b.lemma;
  if (! lemma) { /* CERR << "! inter lemma\n"; */ clear(); return; }


  if (npos != pos_unspec) {

    if (pos == pos_unspec) { // pos was previously unset, copy b.feat

      feats = b.feats;

    } else if (b.pos != pos_unspec) { // a.pos == b.pos (!= pos_unspec) : compute feats intersection

      feats_map::iterator ita, itb;

      for (itb = b.feats.begin(); itb != b.feats.end(); ++itb) {

        attr_def * attr = itb->first;
 
        ita = feats.find(attr);

        if (ita == feats.end()) { // attr not specified in a

          feats.insert(*itb);

        } else { // attr specified in a and b, compute intersection

          feat_set & fs = ita->second;
          fs &= itb->second; // intersect feat_set

          if (! fs) { // empty intersection -> masks are not compatible
            clear(); return;
          }
        }
      }
    }

  } else { feats.clear(); }

  pos = npos;
}


bool lexical_mask2::intersects(const lexical_mask2 & m) const {
 
  if (empty() || m.empty()) { return false; }

  if (! ::intersects(pos, m.pos)) {
    return false;
  }

  if (! (form.intersects(m.form) && lemma.intersects(m.lemma))) {
    return false;
  }

  if (pos == m.pos && pos != pos_unspec) {

    /* check that for each attribute specified in a and b
     * the intersection of the corresponding feat_set is non empty
     */
 
    feats_map::const_iterator ita = feats.begin(), itb = m.feats.begin(),
      enda = feats.end(), endb = m.feats.end();
 
    while (ita != enda && itb != endb) {
      if (ita->first < itb->first) { ++ita; continue; }
      if (itb->first < ita->first) { ++itb; continue; }
      // attribute types matches
      if (! ita->second.intersects(itb->second)) { return false; }
      ++ita, ++itb;
    }
  }

  return true;
}



bool lexical_mask2::intersects(const lexical_mask & m) const {
 
  if (empty() || m.empty()) { return false; }

  if (! ::intersects(pos, m.pos)) {
    return false;
  }

  if ((!m.case_fold.empty()) && (! form.match(m.case_fold))) { return false; }
  if ((!m.lemma.empty()) && ! (lemma.match(m.lemma))) { return false; }


  if (pos == m.pos && pos != pos_unspec) {

    /* check that for each attribute specified in a and b
     * the intersection of the corresponding feat_set is non empty
     */
 
    feats_map::const_iterator ita = feats.begin(), itb = m.feats.begin(),
      enda = feats.end(), endb = m.feats.end();
 
    while (ita != enda && itb != endb) {
      if (ita->first < itb->first) { ++ita; continue; }
      if (itb->first < ita->first) { ++itb; continue; }
      // attribute types matches
      if (! ita->second.intersects(itb->second)) { return false; }
      ++ita, ++itb;
    }
  }

  return true;
}


bool lexical_mask2::in(const lexical_mask2 & m) const {
 
  if (empty()) { return true; }

  if (! ::in(pos, m.pos)) {
    return false;
  }

  if (! (form_set::in(form, m.form) && form_set::in(lemma, m.lemma))) {
    return false;
  }

  if (m.pos != pos_unspec) { // assert(pos == m.pos)
    
    /* check that for each attr where a feat_set b is specified in m,
     * a feat_set a is also specified in *this and (a in b)
     */

    for (feats_map::const_iterator itb = m.feats.begin(); itb != m.feats.end(); ++itb) {
      
      feats_map::const_iterator ita = feats.find((*itb).first);
      
      if ((ita == feats.end()) || (! ::in((*ita).second, (*itb).second))) { return false; }
    }
  }

  return true;
}

namespace {

void feat_val_dump_text(attr_def * attr, const feat_set & fs, std::ostream & os) {
  fs.type->dump_feat_val_set(attr->get_name(), fs.val, attr->do_shortcut(), os);
}

} // namespace ""


void lexical_mask2::dump_text(ostream & os) const {

  if (empty()) { os << "<void>"; return; }

  os << "[" << form << "," << lemma << ".";

  if (pos != pos_unspec) {
    os << pos->get_name();
    for (feats_map::const_iterator it = feats.begin(); it != feats.end(); ++it) {
      feat_val_dump_text(it->first, it->second, os);
    }
  }
  os << ">";
}


