#include <outilex/lexical_mask.h>
#include <outilex/dic_lex_entry.h>
#include <outilex/lexical_entry.h>
#include <outilex/unicode.h>


using namespace std;


/* construct from a dic_lex_entry
 */

lexical_mask::lexical_mask(const dic_lex_entry & e, ling_def * ldef) {

  unspec();

  form = e.form;
  unicode::case_fold(case_fold, form);
  lemma = e.lemma;

  if (e.POS.empty()) { return; }

    
  pos = ldef->get_pos(e.POS);
  if (pos == NULL) {
    if (unknow_attributes.find(e.POS) == unknow_attributes.end()) {
      unknow_attributes.insert(e.POS);
      cerr << "error: lexmask from dic entry: unknown POS : " << e.POS << '\n';
    }
    throw runtime_error("lexmask from dic entry: unknown POS " + e.POS);
  }

  /* first look for defaults values */

  int nattrs = pos->nb_attrs();
  for (int i = 0; i < nattrs; ++i) {
    attr_def * attr = pos->get_attr(i);
    if (attr->get_default_value() != -1) { // if default value is specified set it
      feat_set fs(attr->get_type(), attr->get_default_value());
      feats[attr] = fs;
    }
  }

  for (map<string, string>::const_iterator it = e.feats.begin(), end = e.feats.end();
       it != end; ++it) {

    attr_def * attr = pos->get_attr(it->first);
    if (attr == NULL) {
      if (unknow_attributes.find(it->first) == unknow_attributes.end()) {
        unknow_attributes.insert(it->first);
        cerr << "lexmask:: unknown attribute: '"
          << it->first << "' (in POS " << pos->get_name() << ")\n";
      }
      continue;
    }
  
    feat_set fs(attr->get_type(), it->second);
  
    if (fs && ! fs.is_unspec()) {
      feats[attr] = fs;
    }
  }
}


const feat_set & lexical_mask::operator[](attr_def * attr) const {

  if (pos == NULL || pos == pos_unspec) {
    throw runtime_error("lexmask::operator[](attr_def " + attr->name + "): POS="
                        + (pos ? "unspec" : "NULL"));
  }

  feats_map::iterator it = feats.find(attr);

  if (it != feats.end()) {
    return it->second;
  }

  // feats not present, create an unspec feat_set

  return feats[attr] = feat_set(attr);
}

feat_set & lexical_mask::operator[](attr_def * attr) {

  if (pos == NULL || pos == pos_unspec) {
    throw runtime_error("lexmask::operator[](attr_def " + attr->name + "): POS="
                        + (pos ? "unspec" : "NULL"));
  }

  feats_map::iterator it = feats.find(attr);

  if (it != feats.end()) {
    return it->second;
  }

  // feats not present, create an unspec feat_set

  return feats[attr] = feat_set(attr);
}

const feat_set & lexical_mask::operator[](const string & txt) const {

  if (pos == NULL || pos == pos_unspec) {
    cerr << "error in lexmask::operator[] const, attrname=" << txt << "*this=" << *this << endl;
    throw runtime_error("lexmask::operator[](attrname " + txt + "): POS="
                        + (pos ? "unspec" : "NULL"));
  }

  attr_def * attr = pos->get_attr(txt);
  if (attr == NULL) {
    throw runtime_error("lexmask: no attribute " +txt+ " in POS " + pos->get_name());
  }
  return (*this)[attr];
}

feat_set & lexical_mask::operator[](const string & txt) {

  if (pos == NULL || pos == pos_unspec) {
    cerr << "error in lexmask::operator[], attrname=" << txt << "*this=" << *this << endl;
    throw runtime_error("lexmask::operator[](attrname " + txt + "): POS="
                        + (pos ? "unspec" : "NULL"));
  }

  attr_def * attr = pos->get_attr(txt);
  if (attr == NULL) {
    throw runtime_error("lexmask: no attribute " + txt + " in POS " + pos->get_name());
  }
  return (*this)[attr];
}



#if 0
bool operator==(const lexical_mask & a, const lexical_mask & b) {

  if (& a == & b) { return true; }

  if (! a && ! b) { return true; }

  if (a.pos != b.pos) { return false; }

  if (a.form != b.form) { return false; }

  if (a.lemma != b.lemma) { return false; }

  if (a.feats.size() != b.feats.size()) { return false; }

  return a.feats == b.feats;
}
#endif

bool lexical_mask::set_inter(const lexical_mask & a, const lexical_mask & b) {

  if (& a == this) { set_inter(b); return *this; }
  if (& b == this) { set_inter(a); return *this; }

  if (! a || ! b) { // if one mask is empty return the empty set
    clear(); return false;
  }

  pos = inter(a.pos, b.pos);

  if (pos == 0) { // incompatible POSs
    clear(); return false;
  }

  if (! a.form.empty()) {
    if (! b.form.empty()) {
      if (a.case_fold.empty() || b.case_fold.empty()) {
        throw runtime_error("lexmask::set_inter: error form without case_fold");
      }
      if (a.case_fold != b.case_fold) {
        clear(); return false;
      }
    }
    form = a.form;
    case_fold = a.case_fold;
  } else { form = b.form; case_fold = b.case_fold; }

  if (! a.lemma.empty()) {
    if (! b.lemma.empty()) {
      if (a.lemma != b.lemma) {
        clear(); return false;
      }
    }
    lemma = a.lemma;
  } else { lemma = b.lemma; }



  if (pos != pos_unspec) {

    if (a.pos == pos_unspec) {

      feats = b.feats;

    } else if (b.pos == pos_unspec) {

      feats = a.feats;

    } else { // a.pos == b.pos (!= pos_unspec) : compute feats intersection

      feats = a.feats;
      feats_map::iterator ita;
      feats_map::const_iterator itb;

      for (itb = b.feats.begin(); itb != b.feats.end(); ++itb) {

        attr_def * attr = (*itb).first;
 
        ita = feats.find(attr);

        if (ita == feats.end()) { // attr not specified in a

          feats.insert(*itb);

        } else { // attr specified in a and b, compute intersection

          feat_set & fs = ita->second;
          fs &= itb->second; // intersect feat_set

          if (! fs) { // empty intersection -> masks are not compatible
            clear(); return false;
          }
        }
      }
    }

  } else { feats.clear(); }

  return true; 
}


void lexical_mask::set_inter(const lexical_mask & b) {

  if (empty() || ! b) { // if one mask is empty return the empty set
    clear(); return;
  }

  const pos_def * npos = inter(pos, b.pos);

  if (npos == 0) { // incompatible POSs
    clear(); return;
  }

  if (! form.empty()) {
    if (! b.form.empty()) {
      if (case_fold.empty() || b.case_fold.empty()) {
        throw runtime_error("lexmask:set_inter: form without case_fold");
      }
      if (case_fold != b.case_fold) { clear(); return; }
    }
  } else { form = b.form; case_fold = b.case_fold; }

  if (! lemma.empty()) {
    if (! b.lemma.empty() && lemma != b.lemma) {
      clear();
      return;
    }
  } else { lemma = b.lemma; }


  if (npos != pos_unspec) {

    if (pos == pos_unspec) { // pos was previously unset, copy b.feat

      feats = b.feats;

    } else if (b.pos != pos_unspec) { // a.pos == b.pos (!= pos_unspec) : compute feats intersection

      feats_map::iterator ita;
      feats_map::const_iterator itb;

      for (itb = b.feats.begin(); itb != b.feats.end(); ++itb) {

        attr_def * attr = itb->first;
 
        ita = feats.find(attr);

        if (ita == feats.end()) { // attr not specified in a

          feats.insert(*itb);

        } else { // attr specified in a and b, compute intersection

          feat_set & fs = ita->second;
          fs &= itb->second; // intersect feat_set

          if (! fs) { // empty intersection -> masks are not compatible
            clear(); return;
          }
        }
      }
    }

  } else { feats.clear(); }

  pos = npos;
}


bool lexical_mask::intersects(const lexical_mask & m) const {
 
  /*
  cerr << "intersects " << *this << " n " << m << endl;
  cerr << "fold a = '" << case_fold << "' fold b = '" << m.case_fold << "'\n";
  */

  if (empty() || m.empty()) { return false; }

  if (! ::intersects(pos, m.pos)) {
    return false;
  }

  if (! form.empty() && ! m.form.empty()) {
    if (case_fold.empty() || m.case_fold.empty()) {
      throw runtime_error("lexmask: intersects: form without case_fold");
    }
    if (case_fold != m.case_fold) { return false; }
    // cerr << "case fold matches!\n";
  }

  if (! lemma.empty() && ! m.lemma.empty() && lemma != m.lemma) { return false; }

  //cerr << "jusqu'ici tout va bien\n";

  if (pos == m.pos && pos != pos_unspec) {

    /* check that for each attribute specified in a and b
     * the intersection of the corresponding feat_set is non empty
     */
 
    feats_map::const_iterator ita = feats.begin(), itb = m.feats.begin(),
      enda = feats.end(), endb = m.feats.end();
 
    while (ita != enda && itb != endb) {
      if (ita->first < itb->first) { ++ita; continue; }
      if (itb->first < ita->first) { ++itb; continue; }
      // attribute types matches
      if (! ita->second.intersects(itb->second)) { return false; }
      ++ita, ++itb;
    }
  }

  //  cerr << "inter ok\n";
  return true;
}

bool lexical_mask::in(const lexical_mask & m) const {
 
  if (empty()) { return true; }

  if (! ::in(pos, m.pos)) {
    return false;
  }

  if (! (m.form.empty() || case_fold == m.case_fold)) { return false; }
  if (! (m.lemma.empty() || lemma == m.lemma)) { return false; }

  if (m.pos != pos_unspec) { // assert(pos == m.pos)
    
    /* check that for each attr where a feat_set b is specified in m,
     * a feat_set a is also specified in *this and (a in b)
     */

    for (feats_map::const_iterator itb = m.feats.begin(); itb != m.feats.end(); ++itb) {
      
      feats_map::const_iterator ita = feats.find((*itb).first);
      
      if ((ita == feats.end()) || (! ::in((*ita).second, (*itb).second))) { return false; }
    }
  }

  return true;
}

#if 0
bool lexical_mask::match(const lexical_entry & e) const {

  if (pos != pos_unspec && pos != e.pos) { return false; }

  if (! form.empty() && form != e.form) { return false; }
  if (! lemma.empty() && lemma != e.lemma) { return false; }


  /* check that features are compatible */

  if (pos != pos_unspec) {
    for (feats_map::const_iterator it = feats.begin(); it != feats.end(); ++it) {

      attr_def * attr = it->first;
      const feat_set & fs = it->second;
      int idx = pos->get_attr_idx(attr);

      if (! fs.match(e.feats[idx])) { return false; } 
    }
  }

  /* match */
  return true;
}
#endif
