#include <outilex/xml.h>
#include <outilex/stringtok.h>
#include <outilex/enum_attr.h>

#include <outilex/bool_attr.h>


using namespace std;


attr_type * bool_attr_loader(xmlNodePtr node) {
  return new bool_attr_type(node);
}

//static attr_type_registerer bool_registration("bool", bool_attr_loader);


void bool_attr_type::init_standard_values() {

  value_name.resize(3);
  name_to_value.clear();

  string v = "unset";

  value_name[VALUE_UNSET] = v;
  name_to_value[v] = VALUE_UNSET;

  v = "true";
  value_name[VALUE_TRUE] = v;
  name_to_value[v]     = VALUE_TRUE;
  name_to_value["yes"] = VALUE_TRUE;
  name_to_value["1"]   = VALUE_TRUE;

  v = "false";
  value_name[VALUE_FALSE] = v;
  name_to_value[v]    = VALUE_FALSE;
  name_to_value["no"] = VALUE_FALSE;
  name_to_value["0"]  = VALUE_FALSE;
}

bool_attr_type::bool_attr_type(const std::string & type_name) : enum_attr_type() {
  name = type_name;
  init_standard_values();
}

bool_attr_type::bool_attr_type(xmlNodePtr node) : enum_attr_type() {
  read_XML(node);
}

void bool_attr_type::read_XML(xmlNodePtr node) {

  char * text = xmlGetProp(node, "name");
  name =  text;
  xmlFree(text);

  init_standard_values();

  /* lookup for aliases */

  node = node->xmlChildrenNode;

  while (node) {

    if (xmlStrcmp(node->name, "true") == 0) {

      if ((text = xmlGetProp(node, "alias"))) {
        vector<string> aliases;
        stringtok(text, ",", back_inserter(aliases));
        for (vector<string>::const_iterator it = aliases.begin(); it != aliases.end(); ++it) {
          name_to_value[*it] = VALUE_TRUE;
        }

        if (! aliases.empty()) {
          shortcut[VALUE_TRUE]  = '+' + aliases[0];
          shortcut[VALUE_FALSE] = '-' + aliases[0];
        }
        xmlFree(text);
      }

    } else if (xmlStrcmp(node->name, "false") == 0) {
    
      if ((text = xmlGetProp(node, "alias"))) {
        vector<string> aliases;
        stringtok(text, ",", back_inserter(aliases));
        for (vector<string>::const_iterator it = aliases.begin(); it != aliases.end(); ++it) {
          name_to_value[*it] = VALUE_FALSE;
        }
        if (! aliases.empty()) {
          shortcut[VALUE_FALSE] = '+' + aliases[0];
        }
        xmlFree(text);
      }
    }

    node = node->next;
  }
}



void bool_attr_type::register_shortcut_values(attr_def * attr, pos_def * pos) {

  string shortcut;

  for (map<string, int>::const_iterator it = name_to_value.begin();
       it != name_to_value.end(); ++it) {

    const string & valname = it->first;

    if (valname != "unset"
        && valname != "true" && valname != "yes" && valname != "1"
        && valname != "false" && valname != "no" && valname != "0") {

      shortcut = '+' + valname;
      pos->register_shortcut(shortcut, attr, it->second);

      if (it->second == VALUE_TRUE) {
        shortcut[0] = '-';
        pos->register_shortcut(shortcut, attr, VALUE_FALSE);
      }
    }
  }
}





void bool_attr_type::dump_feat_val(const std::string & attrname, int val,
                                   bool doshortcut, std::ostream & os) const {

  if (! doshortcut || shortcut[val].empty()) {
    os << '+' << attrname << '=' << value_name[val];
    return;
  }
  os << shortcut[val];
}


void bool_attr_type::dump_feat_val_set(const std::string & attrname, const attr_val_set * vs,
                                       bool doshortcut, std::ostream & os) const {

  if (! doshortcut) {
    os << '+' << attrname << '='; dump_val_set_text(vs, os);
  }

  int evs = (int) vs;

  for (int i = 0; i < nb_values(); ++i) {
    if (evs & (1 << i)) {
      if (! shortcut[i].empty()) {
        os << shortcut[i];
      } else {
        os << '+' << attrname << '=' << value_name[i];
      }
    }
  }
}

