#include <string>

#include <outilex/xml.h>
#include <outilex/stringtok.h>

#include <outilex/enum_attr.h>

using namespace std;


/* represents a set of values for a given enum attribute 
 * derives from virtual attr_val_set class (probably useless)
 * perhaps use a struct instead as we don't really use inheritance and RTTI ?
 */


/*
class enum_val_set : public attr_val_set {
public:
  boost::dynamic_bitset<> vals;

  enum_val_set(int size) : vals(size) { vals.set(); }
  enum_val_set(const enum_val_set & vs) : vals(vs.vals) {}
};
*/



/* Implementation of enumeration attribute type
 */


void enum_attr_type::read_XML(xmlNodePtr node) {

  value_name.clear(); name_to_value.clear();

  char * text = xmlGetProp(node, "name");
  name =  text;
  xmlFree(text);

  /* first add 'unset' value (always == 0) */

  int idx = 0;
  string v = "unset";

  value_name.push_back(v);
  name_to_value[v] = idx;
  idx++;

  node = node->xmlChildrenNode;

  while (node) {
    if (xmlStrcmp(node->name, (const xmlChar *) "value") == 0) {

      text = (char *) xmlGetProp(node, (const xmlChar *) "name");
      v = text;

      value_name.push_back(v);
      name_to_value[v] = idx;

      xmlFree(text);

      if ((text = xmlGetProp(node, "alias"))) {
        vector<string> aliases;
        stringtok(text, ",", back_inserter(aliases));
        for (vector<string>::const_iterator it = aliases.begin(); it != aliases.end(); ++it) {
          name_to_value[*it] = idx;
        }
        xmlFree(text);
      }
      idx++;
    }

    node = node->next;
  }
}


/* enum attribute loader routines */

attr_type * enum_attr_loader(xmlNodePtr node) {
  return new enum_attr_type(node);
}

//static attr_type_registerer enum_registration("enum", enum_attr_loader);


const string & enum_attr_type::get_name() const { return name; }


attr_val_set * enum_attr_type::new_val_set() {
  enum_val_set * res = new enum_val_set(nb_values());
  res->set();
  return (attr_val_set *) res;
}

attr_val_set * enum_attr_type::new_val_set(int val) {

  enum_val_set * res = new enum_val_set(nb_values());
  
  if (val == -1) { // everything but unset (= 0)
    res->set();
    res->reset(0);
  } else {
    res->reset();
    res->set(val);
  }
  return (attr_val_set *) res;
}

attr_val_set * enum_attr_type::new_val_set(const attr_val_set * vs) {
  return (attr_val_set *)(new enum_val_set(*((const enum_val_set *)(vs))));
  //return static_cast<attr_val_set *>(new enum_val_set(*(static_cast<const enum_val_set *>(vs))));
}

attr_val_set * enum_attr_type::new_val_set(const string & str) {

  enum_val_set * res = new enum_val_set(nb_values());
  res->reset();

  bool neg = false;

  if (str[0] == '!') { 
    neg = true;
    // set all but 'unset' to true
    res->set();
    res->reset(0); 
  }

  vector<string> vec;
  stringtok(str, "|!", back_inserter(vec));

  for (int i = 0; i < vec.size(); ++i) {

    map<string, int>::iterator it = name_to_value.find(vec[i]);

    if (it == name_to_value.end()) {
      throw xml_parse_error("in enum attribute: " + name + ": unknow value '" + vec[i] + "'");
    }

    if (neg) {
      res->reset((*it).second);
    } else {
      res->set((*it).second);
    }
  }

  return (attr_val_set *)(res);
}


void enum_attr_type::del_val_set(attr_val_set * vs) {
  //delete static_cast<enum_val_set *>(vs);
  delete (enum_val_set *)vs;
}

void enum_attr_type::copy_val_set(attr_val_set * _dest, const attr_val_set * _src) {

  // assert(_dest && _src);

  enum_val_set & dest      = *(reinterpret_cast<enum_val_set *>(_dest));
  const enum_val_set & src = *(reinterpret_cast<const enum_val_set *>(_src));

  dest = src;
}


bool enum_attr_type::is_val_set_empty(attr_val_set * vs) {
  const enum_val_set & evs = *(reinterpret_cast<enum_val_set *>(vs));
  return evs.none();
}

bool enum_attr_type::is_val_set_unspec(attr_val_set * vs) {
  const enum_val_set & evs = *(reinterpret_cast<enum_val_set *>(vs));
  for (int i = 1; i < nb_values(); ++i) {
    if (! evs[i]) { return false; }
  }
  return true;
}

void enum_attr_type::clear_val_set(attr_val_set * vs) {
  enum_val_set & evs = *(reinterpret_cast<enum_val_set *>(vs));
  evs.reset();
}

void enum_attr_type::unset_val_set(attr_val_set * vs) {
  enum_val_set & evs = *(reinterpret_cast<enum_val_set *>(vs));
  evs.reset();
  evs.set(0);
}

void enum_attr_type::set_val_set(attr_val_set * vs) {
  enum_val_set & evs = *(reinterpret_cast<enum_val_set *>(vs));
  evs.set();
  evs.reset(0);
}



bool enum_attr_type::in(const attr_val_set * _a, const attr_val_set * _b) {
  
  const enum_val_set & a = *(reinterpret_cast<const enum_val_set *>(_a));
  const enum_val_set & b = *(reinterpret_cast<const enum_val_set *>(_b));

  return a.is_subset_of(b);
}

bool enum_attr_type::intersect(const attr_val_set * _a, const attr_val_set * _b) {
  
  const enum_val_set & a = *(reinterpret_cast<const enum_val_set *>(_a));
  const enum_val_set & b = *(reinterpret_cast<const enum_val_set *>(_b));

  return a.intersects(b);
}


attr_val_set * enum_attr_type::inter(const attr_val_set * _a, const attr_val_set * _b) {

  const enum_val_set & a = *(reinterpret_cast<const enum_val_set *>(_a));
  const enum_val_set & b = *(reinterpret_cast<const enum_val_set *>(_b));

  attr_val_set * res = reinterpret_cast<attr_val_set *>(new enum_val_set(a & b));
  return res;
}

attr_val_set * enum_attr_type::union_(const attr_val_set * _a, const attr_val_set * _b) {

  const enum_val_set & a = *(reinterpret_cast<const enum_val_set *>(_a));
  const enum_val_set & b = *(reinterpret_cast<const enum_val_set *>(_b));

  attr_val_set * res = reinterpret_cast<attr_val_set *>(new enum_val_set(a | b));
  return res;
}

attr_val_set * enum_attr_type::minus(const attr_val_set * _a, const attr_val_set * _b) {

  const enum_val_set & a = *(reinterpret_cast<const enum_val_set *>(_a));
  const enum_val_set & b = *(reinterpret_cast<const enum_val_set *>(_b));

  attr_val_set * res = reinterpret_cast<attr_val_set *>(new enum_val_set(a - b));
  return res;
}


bool enum_attr_type::equal(const attr_val_set * a_, const attr_val_set * b_) {
  const enum_val_set & a = *(reinterpret_cast<const enum_val_set *>(a_));
  const enum_val_set & b = *(reinterpret_cast<const enum_val_set *>(b_));
  return a == b;
}

bool enum_attr_type::match(int v, const attr_val_set * vs) {
  const enum_val_set & evs = *(reinterpret_cast<const enum_val_set *>(vs));
  return evs.test(v);
}


void enum_attr_type::register_shortcut_values(attr_def * attr, pos_def * pos) {

  string shortcut;

  for (map<string, int>::const_iterator it = name_to_value.begin(); it != name_to_value.end(); ++it) {

    if ((*it).first != "unset") {
      shortcut = '+' + (*it).first;
      pos->register_shortcut(shortcut, attr, it->second);
    }
  }
}



void enum_attr_type::dump_val_set_text(const attr_val_set * vs, std::ostream & os) const {

  const enum_val_set & evs = *(reinterpret_cast<const enum_val_set *>(vs));

  bool already = false;

  for (int i = 0; i < evs.size(); ++i) {
    if (evs.test(i)) {
      if (already) { os << '|'; }
      os << value_name[i];
      already = true;
    }
  }
}

string enum_attr_type::get_val_set_text(const attr_val_set * vs) const {

  string res;
  const enum_val_set & evs = *(reinterpret_cast<const enum_val_set *>(vs));

  bool already = false;

  for (int i = 0; i < evs.size(); ++i) {
    if (evs.test(i)) {
      if (already) { res += '|'; }
      res += value_name[i];
      already = true;
    }
  }
  return res;
}


string enum_attr_type::get_val_text(int val) const { return value_name[val]; }

void enum_attr_type::dump_val_text(int val, ostream & os) const { os << value_name[val]; }


void enum_attr_type::dump_feat_val(const std::string & attrname,
                                   int val, bool shortcut, std::ostream & os) const {
  os << '+';
  if (! shortcut) {
    os <<  attrname << '=';
  }
  os << value_name[val];
}


void enum_attr_type::dump_feat_val_set(const std::string & attrname, const attr_val_set * vs,
                                       bool shortcut, std::ostream & os) const {

  if (! shortcut) {
    os << '+' << attrname << '='; dump_val_set_text(vs, os);
    return;
  }

  const enum_val_set & evs = *(reinterpret_cast<const enum_val_set *>(vs));

  for (int i = 0; i < evs.size(); ++i) {
    if (evs[i]) {
      os << '+' << value_name[i];
    }
  }
}


int enum_attr_type::get_value(const std::string & name) const {
  map<string, int>::const_iterator it = name_to_value.find(name);
  if (it == name_to_value.end()) { return -1; }
  return it->second;
}

