#include <iostream>
#include <string>
#include <map>

#include <outilex/attr_type.h>
#include <outilex/xml.h>

using namespace std;


typedef map<string, attr_type_loader_f> loader_map;


extern attr_type * void_attr_loader(xmlNodePtr node);
extern attr_type * enum_attr_loader(xmlNodePtr node);
extern attr_type * bool_attr_loader(xmlNodePtr node);
extern attr_type * ref_attr_loader(xmlNodePtr node);

namespace {

attr_type_registerer void_registration("void", void_attr_loader);
attr_type_registerer enum_registration("enum", enum_attr_loader);
attr_type_registerer bool_registration("bool", bool_attr_loader);
/* reference is an alias for string */
attr_type_registerer ref_registration("string", ref_attr_loader);
attr_type_registerer string_registration("reference", ref_attr_loader);


//static loader_map attr_loaders; don't work because it is not constructed when registerer are called

loader_map * attr_loaders = NULL;
}


attr_type_registerer::attr_type_registerer(const string & type_name, attr_type_loader_f loader) {
  
  if (attr_loaders == NULL) { // construct the map
    attr_loaders = new loader_map();
  }
  (*attr_loaders)[type_name] = loader;
}


attr_type * new_attr_type(const string & type_name, xmlNodePtr node) {

  if (attr_loaders == NULL) {
    cerr << "error: new_attr_type: no attribute registered!\n";
    return NULL;
  }

  attr_type_loader_f loader = (*attr_loaders)[type_name];
  
  if (loader == NULL) {
    cerr << "new_attr_type: unknow attribute type '" << type_name << "'\n";
    return NULL;
  }

  return loader(node);
}



string attr_type::get_val_text(int val) const {
  ostringstream os;
  dump_val_text(val, os);
  return os.str();
}

string attr_type::get_val_set_text(const attr_val_set * vs) const {
  ostringstream os;
  dump_val_set_text(vs, os);
  return os.str();
}

