#ifndef OUTILEX_APPLY_DICS_
#define OUTILEX_APPLY_DICS_

#include <string>
#include <map>

#include <outilex/xml.h>
#include <outilex/xmlReader.h>
#include <outilex/dicos_list.h>
#include <outilex/text_fsa.h>


struct dico_application_infos {

  dico_application_infos()
    : nbsentence(0), nbtoken(0), nbword(0), nbtag(0), unknown_words(), nbunknwtok(0) {}

  int nbsentence;
  int nbtoken;
  int nbword;
  int nbtag;

  std::map<std::string, int> unknown_words;
  int nbunknwtok; // number of unknown tokens
};

void apply_dics(xmlreader & reader, const dicos_list & dicos, int lookup_flags,
                ling_def * lingdef, otext_fsa & out, dico_application_infos & infos);


#endif
