#include <vector>

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/fstream.hpp>
#include <boost/algorithm/string.hpp>

#include <outilex/dico.h>
#include <outilex/dicos_list.h>


using namespace std;
using namespace boost;
namespace fs = boost::filesystem;

// bigger priority go first

bool compare_by_priority(const dico & a, const dico & b) {
  return a.priority > b.priority;
}


void load_dic(dicos_list & dics, const fs::path & path, int prio) {

  cerr << "loading dic " << path.string() << " (priority = " << prio << ")\n";
  dico * dic = new dico(path, prio);
  assert(dic);
  dics.push_back(dic);
  dics.sort(compare_by_priority);
  cerr << "done.\n";
}


void load_dics(dicos_list & dics, istream & is) {

  string line;
  while (getline(is, line)) {

    string::size_type sharp = line.find('#');
    if (sharp != string::npos) {
      line.erase(sharp);
    }

    trim(line);
    if (line.empty()) { continue; }

    string::size_type colon = line.rfind('|'); 

    int prio = 10;
    if (colon != string::npos) { // read dic priority
      string p = line.substr(colon + 1);
      trim(p);
      prio = lexical_cast<int>(p);
      line.erase(colon);
      trim(line);
    }

    fs::path path(line);
    load_dic(dics, path, prio);
  }
}

void load_dics(dicos_list & dics, const fs::path & path) {
  fs::ifstream is(path);
  load_dics(dics, is);
}
