#include <iostream>
#include <outilex/sax.h>


using namespace std;

namespace {


void on_start_document(void * ctx) {
  ((xml::sax_handler *) ctx)->start_document();
}

void on_end_document(void * ctx) {
  ((xml::sax_handler *) ctx)->end_document();
}

void on_start_element(void * ctx, const xmlChar * n, const xmlChar ** a) {

  const string name((const char *) n);

  map<string, string> attrs;
  if (a) {
    while (*a) {
      attrs[(const char *) *a] = (const char *) *(a+1); 
      a = a + 2;
    }
  }
  ((xml::sax_handler *) ctx)->start_element(name, attrs);
}

void on_end_element(void * ctx, const xmlChar * n) {
  const string name((const char *) n);
  ((xml::sax_handler *) ctx)->end_element(name);
}

void on_characters(void * ctx, const xmlChar * t, int len) {
  const string text((const char *) t, len);
  ((xml::sax_handler *) ctx)->characters(text);
}


void on_cdata_block(void * ctx, const xmlChar * buf, int len) {
  ((xml::sax_handler *) ctx)->cdata_block((const char *) buf, len);
}
};

namespace xml {


xmlSAXHandler sax_handler::libxml_sax_handler  = {
  NULL, /* internalSubset */
  NULL, /* isStandalone */
  NULL, /* hasInternalSubset */
  NULL, /* hasExternalSubset */
  NULL, /* resolveEntity */
  NULL, /* getEntity */
  NULL, /* entityDecl */
  NULL, /* notationDecl */
  NULL, /* attributeDecl */
  NULL, /* elementDecl */
  NULL, /* unparsedEntityDecl */
  NULL, /* setDocumentLocator */
  on_start_document, /* startDocument */
  on_end_document, /* endDocument */
  on_start_element, /* startElement */
  on_end_element, /* endElement */
  NULL, /* reference */
  on_characters, /* characters */
  NULL, /* ignorableWhitespace */
  NULL, /* processingInstruction */
  NULL, /* comment */
  NULL, /* xmlParserWarning */
  NULL, /* xmlParserError */
  NULL, /* xmlParserError */
  NULL, /* getParameterEntity */
  on_cdata_block, /* cdataBlock; */
  NULL, /* externalSubset; */
  1,    // initialised

  NULL, // private
  NULL, /* startElementNs */
  NULL, /* endElementNs */
  NULL  /* xmlStructuredErrorFunc */
};


};
