#ifndef _OUTILEX_SAX_H_
#define _OUTILEX_SAX_H_

#include <string>
#include <map>
#include <boost/filesystem/path.hpp>

#include <libxml/parser.h>

namespace xml {



class sax_handler {

  static xmlSAXHandler libxml_sax_handler;

public:


  virtual ~sax_handler() {}

  
  int parse(const char * fname) {
    return xmlSAXUserParseFile(& libxml_sax_handler, this, fname);
  }

  int parse(const boost::filesystem::path & path) {
    return parse(path.native_file_string().c_str());
  }


  virtual void start_document() {}
  virtual void end_document() {}

  virtual void start_element(const std::string & name,
                             const std::map<std::string, std::string> & attrs) {}
  virtual void end_element(const std::string & name) {}

  virtual void characters(const std::string & text) {}

  virtual void cdata_block(const char * buf, int len) {}
};


template<typename Handler1, typename Handler2>
class compose_sax_handler : public sax_handler {

public:

  Handler1 & h1;
  Handler2 & h2;

  compose_sax_handler(Handler1 & h1_, Handler2 & h2_) 
    : h1(h1_), h2(h2_) {}

  void start_document() { h1.start_document(); h2.start_document(); }
  void end_document() { h1.end_document(); h2.end_document(); }

  void start_element(const std::string & name,
                             const std::map<std::string, std::string> & attrs) {
    h1.start_element(name, attrs); h2.start_element(name, attrs);
  }

  void end_element(const std::string & name) {
    h1.end_element(name); h2.end_element(name);
  }

  void characters(const std::string & text) {
    h1.characters(text); h2.characters(text);
  }

  void cdata_block(const char * buf, int len) {
    h1.cdata_block(buf, len); h2.cdata_block(buf, len);
  }
};


} // namespace xml

#endif
