// header for c module describing a "unicode" string : ustring

#ifndef _h_ustring
#define _h_ustring

#include <stdio.h>
#include "tab_i.h"
#include "llist_i.h"


#define USTRING_LENGTH_MAX 100000
#define UNICODE_FORMAT 0
#define ASCII_FORMAT 1

typedef int Uchar;
typedef Uchar * Ustring;

#include "tab_u.h"

//FUNCTIONS

int ustring_cmp(Ustring u,Ustring v);

int ustring_length(Ustring ustr);

void ustring_free(Ustring ustr);
Ustring ustring_allocation(Uchar arr[]);
Ustring ustring_allocation2(Tab_i arr);

Ustring ustring_copy(Ustring source);
Ustring ustring_strcat(Ustring *start,Ustring end);
Ustring ustring_strcat(Ustring * start, Uchar c);

void ustring_println(Ustring ustr, FILE * f = stdout);
void ustring_print(Ustring ustr, FILE * f = stdout);
void ustring_println_codes(Ustring ustr);
void ustring_println2(Ustring ustr);

Uchar ustring_read_uchar(FILE *f,int encoding);
Ustring ustring_get_line(FILE *f, int encoding);

int ustring_to_int(Ustring ustr);
double ustring_to_double(Ustring ustr);

void ustring_print_array(Ustring u[]);
int ustring_get_next_int(Ustring u,int *pos);

char *ustring_to_string(Ustring u);
Ustring ustring_from_string(char s[]);
Ustring ustring_from_list(Llist_i ll);

char *ustring_alloc_string(char s[]);
void ustring_free_string(char* s);

Ustring ustring_get_substr(Ustring,int,int);
Ustring ustring_get_substr2(Tab_i t,int first,int last);

Uchar ustring_get_uchar(Ustring u,int i);
int ustring_contains(Ustring u,Uchar c);
int ustring_find(Ustring u, Uchar c);
int ustring_find_last(Ustring u,Uchar c);

Tab_u ustring_split(Uchar c,Ustring u);
Tab_u ustring_split_in_order(Ustring s,Ustring u);

void* ustring_malloc(int n);
void ustring_pfree(void *ptr);
void ustring_invert(Ustring *u);
void ustring_append(Ustring *u,int);

void ustring_write(FILE * f,Ustring temp);
void ustring_write_utf_16(FILE * f,Ustring temp);
void ustring_writeln_utf_16(FILE * f,Ustring temp);
void ustring_writeln_utf_16_from_string(FILE * f,char* temp);
void ustring_write_utf_16_from_string(FILE * f,char* temp);
void ustring_write_starting_mark(FILE * f);
void ustring_write_breakline_uchar(FILE * f);

int ustring_write(int fd,Ustring temp);
void ustring_write_utf_16(int fd,Ustring temp);
void ustring_writeln_utf_16(int fd,Ustring temp);
void ustring_writeln_utf_16_from_string(int fd,char* temp);
void ustring_write_utf_16_from_string(int fd,char* temp);
void ustring_write_starting_mark(int fd);
void ustring_write_breakline_uchar(int fd);

Ustring ustring_get_function(Ustring u);
int ustring_print_n_malloc();
int ustring_print_n_free();


#endif
