#ifndef _h_txt 
#define _h_txt

#include "tab_i.h"
#include "tab2_i.h"
#include "tab_u.h"
#include "lexicon.h"


#define TXT_BUFFER_SIZE 1000000

//structures

typedef Tab_i Text;


struct annotated_text{
  Tab_i text;
  Tab2_i analyses;
  Lexicon lexicon;
};

typedef struct annotated_text *A_text;

struct linguistic_analysis{
  Tab_u outputs;
};

typedef struct linguistic_analysis *Analysis;

//Functions


A_text txt_init_a_text();
void txt_free(Text *t);
void txt_free_a_text(A_text *t);
Text txt_get_buffer(FILE **f,int *cnt,char *name,int format);
void txt_print(Text t);
void txt_ustring_print(Text t,Lexicon lex);
void txt_print_a_text(A_text t);
void txt_append_element(Text *t,int element);
int txt_get_element(Text t,int i);
int txt_get_length(Text t);
void txt_append_ustring(Text *t,Ustring u);
Tab_u txt_split(int split,Text t);


int txt_print_n_malloc();
int txt_print_n_free();


#endif
