#include <malloc.h>
#include <stdio.h>
#include <string.h>
#include "text.h"
#include "utilities.h"
#include "ustring.h"

int txt_n_free = 0;
int txt_n_malloc = 0;

void* txt_malloc(int n){
  txt_n_malloc++;
  return (void *)malloc(n);
}

void txt_pfree(void *ptr){
  if(ptr == NULL) return;
  txt_n_free++;
  free(ptr);
  ptr = NULL;
}

int txt_print_n_malloc(){
  printf("txt_malloc=%d\n",txt_n_malloc);
  return txt_n_malloc;
}

int txt_print_n_free(){
  printf("txt_free=%d\n",txt_n_free);
  return txt_n_free;
}

A_text txt_init_a_text(){
  A_text t = (A_text)txt_malloc(sizeof(struct annotated_text));
  if(t == NULL) util_error("txt_init_a_text","Allocation of annotated text");
  t->text = NULL;
  t->analyses = NULL;
  t->lexicon = NULL;
  return t;
}

void txt_free_a_text(A_text *t){
  if((*t) == NULL) return;
  tab_i_free(&((*t)->text));
  tab2_i_free(&((*t)->analyses));
  lex_free(&((*t)->lexicon));
  txt_pfree(*t);
}

void txt_free(Text *t){
  tab_i_free(t);
}

void txt_print(Text t){
  tab_i_println(t);
}

void txt_ustring_print(Text t, Lexicon lex){
  int i,length;
  length = txt_get_length(t);
  for(i = 0 ; i < length ; i++){
    ustring_print(lex_get_element(lex,tab_i_get_value(t,i)));
    printf(" ");
  }
}

void txt_print_a_text(A_text t){
  if(t == NULL){
    printf("(Empty annotated text)");
  }
  tab_i_println(t->text);
  tab2_i_println(t->analyses);
  lex_println(t->lexicon);
}

// format = 0 => unicode (2 bytes)
//format = 1 => ascii (1 byte)

Text txt_get_buffer(FILE **f,int *cnt,char *name,int format){
  Text t = NULL;
  char temp[10000];
  Uchar u;
  int i;
  if(*cnt == 0){
    *f = fopen(name,"r");
    if(*f == NULL) {
      strcpy(temp,"cannot open text file ");
      strcat(temp,name);
      util_error("txt_get_buffer",temp);
    }
    t = NULL;
  }
  for(i = 0 ; i < TXT_BUFFER_SIZE ; i++){
    u = ustring_read_uchar(*f,format);
    if(u == -1) return t;
    tab_i_assign_value(&t,i,u);
  }
  (*cnt)++;
  return t;
}

void txt_append_element(Text *t,int element){
  int n = tab_i_get_n_elements(*t);
  tab_i_assign_value(t,n,element);
}

void txt_append_ustring(Text *t,Ustring u){
  int i,l = ustring_length(u);

  for(i = 0 ; i < l ; i++){
    txt_append_element(t,ustring_get_uchar(u,i));    
  }
}

int txt_get_element(Text t,int i){
  return tab_i_get_value(t,i);
}

int txt_get_length(Text t){
  return tab_i_get_n_elements(t);
}

// split the text : each element split is a delimiter

Tab_u txt_split(int split,Text t){
  Tab_u tab = NULL;
  int c,i,cnt = 0,length = txt_get_length(t);
  Ustring temp = NULL;

  for(i = 0 ; i < length ; i++){
    c = txt_get_element(t,i);
    if(c == split){
      tab_u_assign_value(&tab,cnt,temp);
      ustring_free(temp);
      temp = NULL;
      cnt++;
    }
    else{
      ustring_append(&temp,c);
    }
  }
  if(c != split){
    tab_u_assign_value(&tab,cnt,temp);
    ustring_free(temp);
    temp = NULL;
  }
  return tab;
}
