#include <stdio.h>
#include "ling_representation.h"
#include "grammar.h"
#include "match.h"
#include "automata.h"
#include "llist.h"
#include "llist_l.h"
#include "llist_d.h"
#include "llist_t.h"
#include "llist_i.h"
#include "ustring.h"
#include "tree.h"
#include "tree2.h"
#include "static_tree2.h"
#include "fst2.h"
#include "set_ll.h"
#include "set_i.h"
#include "set_ic.h"
#include "set_icc.h"
#include "tab_i.h"
#include "tab_u.h"
#include "tab_d.h"
#include "tab_l.h"
#include "tab_ll.h"
#include "tab_feat.h"
#include "tab2_i.h"
#include "tab2_u.h"
#include "text.h"
#include "utilities.h"
#include "lexicon.h"
#include "lexicon2.h"
#include "auto2txt.h"
#include "hashtable.h"
#include "stack_f.h"
#include "applications.h"
#include "analysis.h"
#include "syntactic_analysis.h"
#include "dico.h"
#include "alphabet.h"
#include "table.h"

void malloc_free_statistics(){
  int n_malloc = 0;
  int n_free = 0;
  
  printf("=== MALLOC/FREE ===\n");
  n_malloc += ll_print_n_malloc();
  n_free += ll_print_n_free();
  n_malloc += ll_d_print_n_malloc();
  n_free += ll_d_print_n_free();
  n_malloc += ll_t_print_n_malloc();
  n_free += ll_t_print_n_free();
  n_malloc += ll_i_print_n_malloc();
  n_free += ll_i_print_n_free();
  n_malloc += tree_print_n_malloc();
  n_free += tree_print_n_free();
  n_malloc += tree2_print_n_malloc();
  n_free += tree2_print_n_free();
  n_malloc += ustring_print_n_malloc();
  n_free += ustring_print_n_free();
  n_malloc += gram_print_n_malloc();
  n_free += gram_print_n_free();
  n_malloc += fst2_print_n_malloc();
  n_free += fst2_print_n_free();
  n_malloc += set_ll_print_n_malloc();
  n_free += set_ll_print_n_free();
  n_malloc += set_i_print_n_malloc();
  n_free += set_i_print_n_free();
  n_malloc += tab_i_print_n_malloc();
  n_free += tab_i_print_n_free();
  n_malloc += tab_d_print_n_malloc();
  n_free += tab_d_print_n_free();
  n_malloc += tab_u_print_n_malloc();
  n_free += tab_u_print_n_free();
  n_malloc += tab_feat_print_n_malloc();
  n_free += tab_feat_print_n_free();
  n_malloc += util_print_n_malloc();
  n_free += util_print_n_free();
  n_malloc += tab2_i_print_n_malloc();
  n_free += tab2_i_print_n_free();
  n_malloc += tab2_u_print_n_malloc();
  n_free += tab2_u_print_n_free();
  n_malloc += set_ic_print_n_malloc();
  n_free += set_ic_print_n_free();
  n_malloc += set_icc_print_n_malloc();
  n_free += set_icc_print_n_free();
  n_malloc += txt_print_n_malloc();
  n_free += txt_print_n_free();
  n_malloc += lex_print_n_malloc();
  n_free += lex_print_n_free();
  n_malloc += lex2_print_n_malloc();
  n_free += lex2_print_n_free();
  n_malloc += a2t_print_n_malloc();
  n_free += a2t_print_n_free();
  n_malloc += ling_print_n_malloc();
  n_free += ling_print_n_free();
  n_malloc += hash_print_n_malloc();
  n_free += hash_print_n_free();
  n_malloc += match_print_n_malloc();
  n_free += match_print_n_free();
  n_malloc += stack_f_print_n_malloc();
  n_free += stack_f_print_n_free();
  n_malloc += app_print_n_malloc();
  n_free += app_print_n_free();
  n_malloc += ana_print_n_malloc();
  n_free += ana_print_n_free();
  n_malloc += sa_print_n_malloc();
  n_free += sa_print_n_free();
  n_malloc += tab_l_print_n_malloc();
  n_free += tab_l_print_n_free();
  n_malloc += dico_print_n_malloc();
  n_free += dico_print_n_free();
  n_malloc += ll_l_print_n_malloc();
  n_free += ll_l_print_n_free();
  n_malloc += tab_ll_print_n_malloc();
  n_free += tab_ll_print_n_free();
  n_malloc += alph_print_n_malloc();
  n_free += alph_print_n_free();
  n_malloc += table_print_n_malloc();
  n_free += table_print_n_free();

  printf("---------------\n");
  printf("n_malloc=%d\n",n_malloc);
  printf("n_free=%d\n",n_free);
  printf("====  ===  ====\n");
}


Text test_tokenization(Tokens *tok,char *text_file,char *grammar_file){
  struct a2t_context context;
  struct a2t_result result;
  Text new_text,t;
  Grammar gram;
  int fd[10];
  FILE *f = NULL;
  int cnt = 0;

  printf("Tokenizing text\nLoading tokenization grammar\n");
  gram = fst2_load_graph(grammar_file,UNICODE_FORMAT,NULL);
  printf("Loading text\n");
  t = txt_get_buffer(&f,&cnt,text_file,UNICODE_FORMAT);
  fclose(f);
  gram_change_morpho_terminals(&gram);
  
  a2t_init_context(&context,tok,gram,1,t,0,APP_TOKENIZATION,fd,0,"output_config",NULL,NULL);
  a2t_init_result(&result);
  printf("Tokenizing...\n");
  a2t_apply_grammar(&context,&result);
  //txt_print(result.new_text);
  //  tok_println(context.tokens);
  //tab_l_println(result.tok_features);
  new_text = result.new_text;  
  a2t_free_context(&context,A2T_NOT_FREE_TOKENS);
  a2t_free_result(&result,A2T_NOT_FREE_RESULT_TEXT);
  printf("Done\n");
  return new_text;
}



int main(){
  //  Text t = NULL;
  Table tab = NULL;
  tab = table_load("V_3.txt",NULL,ASCII_FORMAT,TABLE_ONE_ROW_HEADER);
  table_print(tab);
  table_free(&tab);



  // Alphabet alph = alph_load("/home/mconstant/unitex/French/Alphabet.txt",UNICODE_FORMAT);
  //Dico dic = NULL;
  //Tokens tok;
  //tok_init(&tok);

  // other text files:
  //"/home/ladl/mconstan/unitex/English/Corpus/ivanhoe.txt"
  //"/home/mconstant/test_text.txt"
  // "/home/mconstant/unitex/English/Corpus/ivanhoe.txt"

  //other grammars
  //"/home/ladl/mconstan/unitex/English/Graphs/morpho.fst2"
  //"/home/mconstant/tokenization.fst2"
  
  //  t = test_tokenization(&tok,"/home/mconstant/unitex/French/Corpus/sample.txt","/home/mconstant/tokenization.fst2");
  //txt_print(t);
  //txt_ustring_print(t,tok_get_lexicon(tok));
  //printf("Loading dicos\n");
  //dico_load(&dic,"/home/mconstant/unitex/French/Corpus/sample_snt/dlc",UNICODE_FORMAT,&tok);
  //dico_load(&dic,"/home/mconstant/unitex/French/Corpus/sample_snt/dlf",UNICODE_FORMAT,&tok);
  /* int i,l = txt_get_length(t);
  Llist compounds = NULL;
  lex_print_codes(dic->compound_lexicon);
  for(i = 0 ; i < l ; i++){
    compounds =  alph_get_indexes_insensitive_from_lexicon(t,i,dic->compound_lexicon,alph,tok_get_lexicon_tab(tok));
    if(compounds != NULL){ printf("%d::",i);ll_println(compounds);}
    ll_free(&compounds);
  }
  */
  /*
  printf("Loading grammar\n");
  gram = fst2_load_graph("/home/mconstant/unitex/French/Graphs/test_syntax.fst2",FST2_UNITEX_FORMAT,&tok);
  printf("Loading text\n");
  
  a2t_init_context(&context,&tok,gram,1,t,0, APP_PARSING,fd,0,"output_config",NULL,NULL);
  a2t_init_result(&result);
  printf("Applying grammar on text\n");
  a2t_apply_grammar(&context,&result);
  //txt_print(result.new_text);
  //  tok_println(context.tokens);
  //tab_l_println(result.tok_features);
  a2t_free_context(&context,A2T_FREE_TOKENS);
  a2t_free_result(&result,A2T_FREE_RESULT_TEXT);
  printf("Done\n");
  */
  // gram_free(&gram);
  // tab_i_free(&ti);

  //  alph_print(alph);
  
  //malloc_free_statistics();
  return 0;
}
