#include <stdio.h>
#include <malloc.h>
#include "tab_l.h"
#include "utilities.h"

int tab_l_n_free = 0;
int tab_l_n_malloc = 0;

void* tab_l_malloc(int n){
  tab_l_n_malloc++;
  return (void *)malloc(n);
}

void tab_l_pfree(void *ptr){
  if(ptr == NULL) return;
  tab_l_n_free++;
  free(ptr);
  ptr = NULL;
}

int tab_l_print_n_malloc(){
  printf("tab_l_malloc=%d\n",tab_l_n_malloc);
  return tab_l_n_malloc;
}

int tab_l_print_n_free(){
  printf("tab_l_free=%d\n",tab_l_n_free);
  return tab_l_n_free;
}


Tab_l tab_l_init(){
  Tab_l t;
  t = (Tab_l)tab_l_malloc(sizeof(struct tab_l));
  if(t == NULL) util_error("tab_l_init","allocation of new Tab_l");
  t->tab = NULL;
  t->n_elements = 0;
  t->MAX = 0;
  return t;
}

Llist *tab_l_alloc_space(Llist *t,int size){
  if(t == NULL){
    return (Llist *)tab_l_malloc(size);
  }  
  return (Llist *)realloc(t,size);
}

void tab_l_init_space(Llist **t,int start,int tab_size){
  int i;

  for(i = start ; i < tab_size ; i++){
    (*t)[i] = NULL;
  }  
}

void tab_l_insert_value(Tab_l *t,int index,int key,int value){
  int size,start;
  if(*t == NULL){
    *t = tab_l_init();
  }
  size = ((index/TAB_L_STEP_ALLOC)+1) * TAB_L_STEP_ALLOC;
  start = (*t)->MAX;
  if(index >= (*t)->MAX){
    (*t)->tab = tab_l_alloc_space((*t)->tab,size*sizeof(Llist));
    (*t)->MAX = size;
  }
  if((*t)->tab == NULL) util_error("tab_l_assign_value","allocation of array in Tab_l");  
  tab_l_init_space(&((*t)->tab),start,(*t)->MAX);
  if((*t)->tab[index] == NULL){
    ((*t)->n_elements)++;
  }
  ll_insert(&((*t)->tab[index]),key,value);
}

void tab_l_insert_value_sorted(Tab_l *t,int index,int key,int value,int option){
  int size, start;
if(*t == NULL){
    *t = tab_l_init();
  }
  size = ((index/TAB_L_STEP_ALLOC)+1) * TAB_L_STEP_ALLOC;
  start = (*t)->MAX;
  if(index >= (*t)->MAX){
    (*t)->tab = tab_l_alloc_space((*t)->tab,size*sizeof(Llist));
    (*t)->MAX = size;
  }
  if((*t)->tab == NULL) util_error("tab_l_assign_value","allocation of array in Tab_l");  
  tab_l_init_space(&((*t)->tab),start,(*t)->MAX);
  if((*t)->tab[index] == NULL){
    ((*t)->n_elements)++;
  }
  ll_insert_sorted(&((*t)->tab[index]),key,value,0);
}

void tab_l_set_list(Tab_l *t,int index,Llist l){
  int size,start;

if(*t == NULL){
    *t = tab_l_init();
  }
  size = ((index/TAB_L_STEP_ALLOC)+1) * TAB_L_STEP_ALLOC;
  start = (*t)->MAX;
  if(index >= (*t)->MAX){
    (*t)->tab = tab_l_alloc_space((*t)->tab,size*sizeof(Llist));
    (*t)->MAX = size;
  }
  if((*t)->tab == NULL) util_error("tab_l_assign_value","allocation of array in Tab_l");  
  tab_l_init_space(&((*t)->tab),start,(*t)->MAX);
  if((*t)->tab[index] == NULL){
    ((*t)->n_elements)++;
  }
  ll_free(&((*t)->tab[index]));
  (*t)->tab[index] = l;
}


Llist tab_l_get_list(Tab_l t,int index){
  if(t == NULL) return NULL;
  if(t->MAX <= index){
    return NULL;
  }
  return t->tab[index];
}

int tab_l_get_n_elements(Tab_l t){
  if(t == NULL) return 0;
  return t->n_elements;
}
int tab_l_get_MAX(Tab_l t){
  if(t == NULL) return 0;
  return t->MAX;
}

void tab_l_free(Tab_l *t){
  int i;
  if(*t == NULL) return;
  for(i = 0 ; i < (*t)->MAX ; i++){    
    if((*t)->tab[i] != NULL){
      ll_free(&((*t)->tab[i]));
    }
  }
  tab_l_pfree((*t)->tab);
  tab_l_pfree(*t);
}

void tab_l_print(Tab_l t){
  int i;

  if(t == NULL){
    printf("NULL TAB_L ");
    return;
  }
  for(i = 0 ; i < t->MAX ; i++){
    printf("%d:",i);
    ll_println(t->tab[i]);
  }
}

void tab_l_println(Tab_l t){
  tab_l_print(t);
  printf("\n");
}
