#ifndef _h_tab_feat 
#define _h_tab_feat

#include "set_ll.h"
#include "set_ic.h"
#include "hashtable.h"

#define TAB_FEAT_HT_LABELS_SIZE 20000
#define TAB_FEAT_HT_TYPES_SIZE 10

struct boolean_feature{
  int label;
  int type;
};

typedef struct boolean_feature * Boolean_feature;


struct tab_feat{
  int n_elements;
  Boolean_feature *features;
  Hashtable ht_labels;
  Hashtable ht_types;
};

typedef struct tab_feat * Tab_feat;


// FUNCTIONS

Boolean_feature tab_feat_get_element(Tab_feat t,int type);
int tab_feat_add_element(Tab_feat *t,int type,int label);
int tab_feat_print_n_malloc();
int tab_feat_print_n_free();
void tab_feat_println(Tab_feat t);
void tab_feat_print(Tab_feat t);
void tab_feat_free(Tab_feat *t);

#endif
