#include <stdio.h>
#include <malloc.h>
#include "tab2_u.h"
#include "utilities.h"

int tab2_u_n_free = 0;
int tab2_u_n_malloc = 0;

void* tab2_u_malloc(int n){
  tab2_u_n_malloc++;
  return (void *)malloc(n);
}

void tab2_u_pfree(void *ptr){
  if(ptr == NULL) return;
  tab2_u_n_free++;
  free(ptr);
  ptr = NULL;
}

int tab2_u_print_n_malloc(){
  printf("tab2_u_malloc=%d\n",tab2_u_n_malloc);
  return tab2_u_n_malloc;
}

int tab2_u_print_n_free(){
  printf("tab2_u_free=%d\n",tab2_u_n_free);
  return tab2_u_n_free;
}

Tab2_u tab2_u_init(){
  Tab2_u t = (Tab2_u)tab2_u_malloc(sizeof(struct tab2_u));
  if(t == NULL) util_error("tab2_u_init","allocation of tab2_u");
  t->n_rows = 0;
  t->n_rows_MAX = 0;
  t->n_columns = 0;
  t->tab = NULL;
  return t;
}

Tab_u *tab2_u_alloc_space(Tab_u *t,int size){
  if(t == NULL){
    return (Tab_u *)tab2_u_malloc(size);
  }  
  return (Tab_u *)realloc(t,size);
}

void tab2_u_init_space(Tab_u **t,int start,int tab_size){
  int i;

  for(i = start ; i < tab_size ; i++){
    (*t)[i] = NULL;
  }  
}


void tab2_u_assign_value(Tab2_u *t,int i,int j,Ustring value){
  int size,start;

  if(*t == NULL){

    *t = tab2_u_init();
  }
  start = (*t)->n_rows_MAX;
  size = ((i/TAB2_U_STEP_ALLOC)+1)*TAB2_U_STEP_ALLOC;
  if((*t)->n_rows_MAX <= i){
    (*t)->tab = tab2_u_alloc_space((*t)->tab,size*sizeof(struct tab2_u));
    (*t)->n_rows_MAX = size;
  }
  if((*t)->tab == NULL) util_error("tab2_u_assign_value","allocation of row vector");; 
  tab2_u_init_space(&((*t)->tab),start,(*t)->n_rows_MAX);
  if((*t)->tab[i] == NULL){
    ((*t)->n_rows)++;
  }
  tab_u_assign_value(&((*t)->tab[i]),j,value);
}

Ustring tab2_u_get_value(Tab2_u t,int i,int j){
  if(t == NULL) return NULL;
  if(i >= t->n_rows_MAX) return NULL;
  return tab_u_get_value(t->tab[i],j);
}

int tab2_u_get_n_rows_MAX(Tab2_u t){
  if(t == NULL) return 0;
  return (t->n_rows_MAX);
}

int tab2_u_get_n_columns_MAX(Tab2_u t,int i){
  if(t == NULL) return 0;
  if(t->tab == NULL) return 0;
  if(i >= t->n_rows_MAX) return 0;
  return tab_u_get_MAX(t->tab[i]);
}

int tab2_u_get_n_rows(Tab2_u t){
  if(t == NULL) return 0;
  return t->n_rows;
}

int tab2_u_get_n_columns(Tab2_u t,int row_id){
  if(t == NULL) return 0;
  if(t->n_rows <= row_id) return 0;
  return tab_u_get_n_elements(t->tab[row_id]); 
}

void tab2_u_free(Tab2_u *t){  
  int i;
  if(*t == NULL) return;
  for(i = 0 ; i < (*t)->n_rows_MAX ; i++){
    tab_u_free(&((*t)->tab[i])); 
  }
  tab2_u_pfree((*t)->tab);
  tab2_u_pfree(*t);
}


void tab2_u_print(Tab2_u t){
  int i;

  if((t == NULL)||(t->tab == NULL)){
    printf("[empty matrix]");
    return;
  }
  printf("-------- MATRIX --------\n");
  for(i = 0 ; i < t->n_rows_MAX ; i++){
    printf("%d::",i);
    tab_u_println(t->tab[i]);
  }
  printf("------------------------\n");
}

void tab2_u_println(Tab2_u t){
  tab2_u_print(t);
  printf("\n");
}
