// HEADER of a c module implementing a tree containing words (ustring)
// There is a reverse pointer allowing us to go backward

#ifndef _h_stree2
#define _h_stree2

#include "tree2.h"
#include "tab_i.h"

//struture of a tree_node

struct stree2_node{
  int n_siblings;
  struct stree2_node **siblings;
  Tab_i letters; 
  struct stree2_node *previous;
  int mark;
};

typedef struct stree2_node * Stree2_node;

// FUNCTIONS

void stree2_from_tree2(struct stree2_node **sroot,struct tree2_node *root);
int stree2_word_exists(struct stree2_node *root,int *w);
struct stree2_node *stree2_init();
int stree2_print_n_malloc();
int stree2_print_n_free();
void stree2_pfree(void *ptr);
void* stree2_malloc(int n);
void stree2_free(struct stree2_node **n);
int* stree2_get_element(struct stree2_node *n);

#endif
