#include "stack_f.h"
#include "utilities.h"
#include <stdlib.h>
#include <stdio.h>

int stack_f_n_free = 0;
int stack_f_n_malloc = 0;

void* stack_f_malloc(int n){
  stack_f_n_malloc++;
  return (void *)malloc(n);
}

void stack_f_pfree(void *ptr){
  if(ptr == NULL) return;
  stack_f_n_free++;
  free(ptr);
  ptr = NULL;
}

int stack_f_print_n_malloc(){
  printf("stack_f_malloc=%d\n",stack_f_n_malloc);
  return stack_f_n_malloc;
}

int stack_f_print_n_free(){
  printf("stack_f_free=%d\n",stack_f_n_free);
  return stack_f_n_free;
}

void stack_f_init(Stack_f *stack){
  *stack = NULL;
}


int  stack_f_is_empty(Stack_f stack){
  return (stack == NULL);
}

struct stack_f_element * stack_f_create_element(int automaton,int state){
  struct stack_f_element *elem = (struct stack_f_element *)stack_f_malloc(sizeof(struct stack_f_element));
  if(elem == NULL) util_error("stack_f_init_element","initialisation of stack_f_element");
  elem->automaton = automaton;
  elem->state = state;
  elem->next = NULL;
  return elem;
}

void stack_f_push(Stack_f *stack,int automaton,int state){
  struct stack_f_element *elem = stack_f_create_element(automaton,state);
  elem->next = *stack;
  *stack = elem;
}

struct stack_f_element* stack_f_pull(Stack_f *stack){
  struct stack_f_element *ptr;

  if(*stack == NULL) return NULL;
  ptr = *stack;
  *stack = (*stack)->next;

  return ptr;
}

void stack_f_free_element(struct stack_f_element **ptr){
  if(*ptr == NULL) return;
  stack_f_pfree(*ptr);
}



void stack_f_free(Stack_f *stack){
  struct stack_f_element *ptr;

  while(*stack != NULL){
    ptr = *stack;
    *stack = (*stack)->next;
    stack_f_free_element(&ptr);    
  }
}


void stack_f_zero(Stack_f *stack){
  stack_f_free(stack);
  *stack = NULL;
}


void stack_f_print(Stack_f stack){
  struct stack_f_element *ptr = stack;
  if(ptr == NULL){
    printf("EMPTY STACK\n");
    return;
  }
  while(ptr != NULL){
    printf("(%d,%d)",ptr->automaton,ptr->state);
    ptr = ptr->next;
  }
  printf("\n");
}


int stack_f_get_state(struct stack_f_element elem){
  return elem.state;
}

int stack_f_get_automaton(struct stack_f_element elem){
  return elem.automaton;
}

int stack_f_get_parent(struct stack_f_element elem){
  return elem.state;
}

int stack_f_get_current(struct stack_f_element elem){
  return elem.automaton;
}


Stack_f stack_f_copy(Stack_f stack){
  struct stack_f_element *ptr1,*ptr2;
  Stack_f res = NULL;
  
  if(stack == NULL) return NULL;
  res = stack_f_create_element(stack->automaton,stack->state);
  ptr1 = stack;
  ptr2 = res;
  while(ptr1->next != NULL){
    ptr1 = ptr1->next;
    ptr2->next = stack_f_create_element(ptr1->automaton,ptr1->state);
    ptr2 = ptr2->next;
  }
  return res;
}
