#include <stdio.h>
#include <malloc.h>
#include "set_ic.h"
#include "utilities.h"

int set_ic_n_free = 0;
int set_ic_n_malloc = 0;

void* set_ic_malloc(int n){
  set_ic_n_malloc++;
  return (void *)malloc(n);
}

void set_ic_pfree(void *ptr){
  if(ptr == NULL) return;
  set_ic_n_free++;
  free(ptr);
  ptr = NULL;
}

int set_ic_print_n_malloc(){
  printf("set_ic_malloc=%d\n",set_ic_n_malloc);
  return set_ic_n_malloc;
}

int set_ic_print_n_free(){
  printf("set_ic_free=%d\n",set_ic_n_free);
  return set_ic_n_free;
}

Set_ic set_ic_intersection(Set_ic s1,Set_ic s2){
  Set_ic s = NULL;
  int i,j,l,val1,val2,n_r;

  if(s1 == NULL) return NULL;
  if(s2 == NULL) return NULL;
  n_r = util_min(tab2_i_get_n_rows_MAX(s1),tab2_i_get_n_rows_MAX(s2));
  for(i = 0 ; i < n_r ; i++){
    l = util_min(tab2_i_get_n_columns_MAX(s1,i),tab2_i_get_n_columns_MAX(s2,i));
    for(j = 0 ; j < l ; j++){
      val1 = tab2_i_get_value(s1,i,j);
      val2 = tab2_i_get_value(s2,i,j);
      tab2_i_assign_value(&s,i,j,val1 & val2);
    }
  }
  return s;
}

Set_ic set_ic_union(Set_ic s1,Set_ic s2){
  Set_ic s = NULL;
  int i,j,l,val1,val2,n_r;

  n_r = util_max(tab2_i_get_n_rows_MAX(s1),tab2_i_get_n_rows_MAX(s2));
  for(i = 0 ; i < n_r ; i++){
    l = util_max(tab2_i_get_n_columns_MAX(s1,i),tab2_i_get_n_columns_MAX(s2,i));
    for(j = 0 ; j < l ; j++){
      val1 = tab2_i_get_value(s1,i,j);
      if(val1 == -1) val1 = 0;
      val2 = tab2_i_get_value(s2,i,j);
      if(val2 == -1) val2 = 0;
      tab2_i_assign_value(&s,i,j,val1 | val2);
    }
  }
  return s;
}

int set_ic_exists(Set_ic s,int elem){
  int n_b,i,j,val,size1,size2,val2;

  size1 = 8*sizeof(int);
  size2 = size1*SET_IC_N_COLUMNS_MAX;
  i = elem/size2;
  j = (elem-i*size2)/size1;  
  n_b = (elem-i*size2) % size1;
  val = 1;
  val = val << n_b;
  val2 = tab2_i_get_value(s,i,j);
  if(val2 == -1){
    val2 = 0;
  }
  return (val & val2);
}

int set_ic_add_element(Set_ic *s,int elem){
  int n_b,i,j,val,size1,size2,val2;

  size1 = 8*sizeof(int);
  size2 = size1*SET_IC_N_COLUMNS_MAX;
  i = elem/size2;
  j = (elem-i*size2)/size1;  
  n_b = (elem-i*size2) % size1;
  val = 1;
  val = val << n_b;
  val2 = tab2_i_get_value(*s,i,j);
  if(val2 == -1){
    val2 = 0;
  }
  val |= val2;
  tab2_i_assign_value(s,i,j,val);
  return 0;
}

int set_ic_rm_element(Set_ic *s,int elem){
  int n_b,i,j,val,size1,size2,val2;

  size1 = 8*sizeof(int);
  size2 = size1*SET_IC_N_COLUMNS_MAX;
  i = elem/size2;
  j = (elem-i*size2)/size1;  
  n_b = (elem-i*size2) % size1;
  val = 1;
  val = val << n_b;
  val2 = tab2_i_get_value(*s,i,j);
  if(val2 == -1){
    return 0;
  }
  val = util_bit_removal(val,val2);
  tab2_i_assign_value(s,i,j,val);
  return 0;
}


void set_ic_print(Set_ic t){
  int i,j,k,val,size1,size2,n;
 
  if(t == NULL){
    printf("(empty)");
    return;
  }
  size1 = 8* sizeof(int);
  size2 = size1*SET_IC_N_COLUMNS_MAX;
  printf("(");
  for(i = 0 ; i < t->n_rows_MAX ; i++){
    if(t->tab[i] != NULL){
      n = tab_i_get_MAX(t->tab[i]);
      for(j = 0 ; j < n ;j++){
	for(k = 0 ; k < size1 ; k++){
	  val = 1;
	  val = val << k;
	  if(tab_i_get_value(t->tab[i],j) & val){
	    printf("%d;",size2*i+size1*j+k);
	  }
	}
      }
    }
  }
  printf(")");
}

void set_ic_println(Set_ic t){
  set_ic_print(t);
  printf("\n");
}

void set_ic_flush(Set_ic *s){
  set_ic_free(s);
}

void set_ic_free(Set_ic *s){
  tab2_i_free(s);
}

