#ifndef _h_match 
#define _h_match

#include "tab_i.h"
#include "syntactic_analysis.h"

#define TAB_M_STEP_ALLOC 8
#define TAB_M_HACHAGE_MAX 32768

struct match{
  int length;
  int match_result;
  Llist recognized;
  Llist analysis;
  int output;
  int final;
  double weight;
  int subauto_open;
  int subauto_close;
  Tab_i children; // next matches
  int parent; //previous match
};

typedef struct match Match;


typedef Match *Match_node;


struct tab_m{
  Match_node *tab;
  int n_elements;
  int MAX;
};

typedef struct tab_m* Tab_m;

struct match_tree{
  int n_tree;
  int n_finaux;
  Tab_m tree;
  Tab_i finaux; // les numeros des noeuds finaux de l'arbre
  Tab_i initiaux; // les numeros des noeuds initiaux de l'arbre
};

typedef struct match_tree *Match_tree;

//fonctions
int match_print_n_malloc();
int match_print_n_free();
void match_print(Match_tree t);
void match_print_unique(Match_tree t,Match_node n);
int match_add(Match_tree *tree, Match_node node, int parent);
Match_node match_create(int l,int res,int output,double weight,Llist analysis,Llist recognized);
Match_node match_get(Match_tree tree,int node_index);
void match_add_final(Match_tree *tree,int node_index,Match_node node);
void match_free_tree(Match_tree *tree);
int match_find_best(Match_tree t,Match_node *best,int calc_type);
void match_set_subauto_open(Match_node n,int subauto);
void match_set_subauto_close(Match_node n,int subauto);
Match_node match_tab_m_get_value(Tab_m t,int index);
Syntactic_tree match_to_sa_tree(Match_tree mtree,Match_node match);
#endif
