#ifndef _h_ll_t
#define _h_ll_t


// HEADER FOR LINKED LIST LIBRARY

//structure of a cell of a linked list

struct ll_t_cell{
  unsigned int key;
  unsigned int value;
  unsigned int id;
  struct ll_t_cell *next;
};

struct linked_list_t{
  struct ll_t_cell *head;
  struct ll_t_cell *tail;
};

typedef struct linked_list_t * Llist_t; 

//FUNCTIONS

void ll_t_insert_at_tail(Llist_t *l,unsigned int k,unsigned int v,unsigned int id);
void ll_t_insert_sorted(Llist_t *l,unsigned int k,unsigned int v,unsigned int id,int option);
struct ll_t_cell* ll_t_find_element(Llist_t l,int elem,int option);
struct ll_t_cell* ll_t_find_element2(Llist_t l,int k,int v);
void ll_t_print(Llist_t l);
void ll_t_println(Llist_t l);
void ll_t_free(Llist_t *l);
int ll_t_print_n_malloc();
int ll_t_print_n_free();
int ll_t_length(Llist_t ll);

#endif
