#ifndef _h_ll_l
#define _h_ll_l

#include "llist.h"

// HEADER OF LIBRARY FOR LINKED LIST OF LLIST


#define LL_L_COMPLETE_FREE 1
#define LL_L_LIGHT_FREE 0

//structure of a cell of a linked list of llist

struct ll_l_cell{
  Llist list;
  struct ll_l_cell *next;
};

struct linked_list_l{
  struct ll_l_cell *head;
  struct ll_l_cell *tail;
};

typedef struct linked_list_l * Llist_l; 

//FUNCTIONS

void ll_l_insert_at_tail(Llist_l *l,Llist list);
void ll_l_insert(Llist_l *l,Llist list); //head 
void ll_l_add_llist_l(Llist_l *l,Llist_l list);

void ll_l_print(Llist_l l);
void ll_l_println(Llist_l l);

void ll_l_free(Llist_l *l);
void ll_l_light_free(Llist_l *l);//do not free the llists

int ll_l_print_n_malloc();
int ll_l_print_n_free();

#endif
