#include <stdio.h>
#include <malloc.h>
#include "llist_l.h"
#include "utilities.h"

int ll_l_n_free = 0;
int ll_l_n_malloc = 0;

void* ll_l_malloc(int n){
  ll_l_n_malloc++;
  return (void *)malloc(n);
}

void ll_l_pfree(void *ptr){
  if(ptr == NULL) return;
  ll_l_n_free++;
  free(ptr);
  ptr = NULL;
}

int ll_l_print_n_malloc(){
  printf("ll_l_malloc=%d\n",ll_l_n_malloc);
  return ll_l_n_malloc;
}

int ll_l_print_n_free(){
  printf("ll_l_free=%d\n",ll_l_n_free);
  return ll_l_n_free;
}


struct ll_l_cell* ll_l_create_cell(Llist l){
  struct ll_l_cell *ptr = (struct ll_l_cell*)ll_l_malloc(sizeof(struct ll_l_cell));
  ptr->list = l;
  ptr->next = NULL;
  return ptr;
}

Llist_l ll_l_initialize(){
  Llist_l ptr = (Llist_l)ll_l_malloc(sizeof(struct linked_list_l));
  ptr->head = NULL;
  ptr->tail = NULL;
  return ptr;
}

void ll_l_insert(Llist_l *l,Llist list){
   struct ll_l_cell *ptr = ll_l_create_cell(list);

  if(ptr == NULL) util_error("ll_l_insert_at_tail","creating cell");
  if(*l == NULL){
    *l = ll_l_initialize();
  }
   if(*l == NULL)  util_error("ll_l_insert_at_tail","llist initialization");
   ptr->next =(*l)->head;
   (*l)->head = ptr; 
}

void ll_l_insert_at_tail(Llist_l *l,Llist list){
  struct ll_l_cell *ptr = ll_l_create_cell(list);

  if(ptr == NULL) util_error("ll_l_insert_at_tail","creating cell");
  if(*l == NULL){
    *l = ll_l_initialize();
  }
  if(*l == NULL)  util_error("ll_l_insert_at_tail","llist initialization");
  if((*l)->head == NULL){
    (*l)->head = ptr;
    (*l)->tail = (*l)->head;
    return;
  }
  (*l)->tail->next = ptr;
  (*l)->tail = (*l)->tail->next;
}

void ll_l_add_llist_l(Llist_l *l,Llist_l list){
  struct ll_l_cell *ptr;
  if(list == NULL) return;
  if(*l == NULL){
    *l = list;
  }
  else{
    ptr = list->head;
    while(ptr != NULL){
      ll_l_insert(l,ptr->list);
      ptr = ptr->next;
    }    
  }
}

void ll_l_print(Llist_l l){
  struct ll_l_cell *ptr;

  if(l == NULL) {
    printf("-- NULL LIST OF LLIST --\n");
    return;
  }
  ptr = l->head;
  while(ptr != NULL){
    ll_println(ptr->list);
    ptr = ptr->next;
  }
}


void ll_l_println(Llist_l l){
  ll_l_print(l);
}


void ll_l_various_free(Llist_l *l,int is_complete){
  struct ll_l_cell *ptr;

  if(*l != NULL){
    while((*l)->head != NULL){
      ptr = (*l)->head;
      (*l)->head = (*l)->head->next;
      if(is_complete) ll_free(&(ptr->list));
      ll_l_pfree(ptr);
    }
    ll_l_pfree(*l);
    *l = NULL;
  }
}


void ll_l_free(Llist_l *l){
  ll_l_various_free(l,LL_L_COMPLETE_FREE);
}

void ll_l_light_free(Llist_l *l){
  ll_l_various_free(l,LL_L_LIGHT_FREE);
}
