#include <stdio.h>
#include <malloc.h>
#include "llist_i.h"
#include "utilities.h"

int ll_i_n_free = 0;
int ll_i_n_malloc = 0;

void* ll_i_malloc(int n){
  ll_i_n_malloc++;
  return (void *)malloc(n);
}

void ll_i_pfree(void *ptr){
  if(ptr == NULL) return;
  ll_i_n_free++;
  free(ptr);
  ptr = NULL;
}

int ll_i_print_n_malloc(){
  printf("ll_i_malloc=%d\n",ll_i_n_malloc);
  return ll_i_n_malloc;
}

int ll_i_print_n_free(){
  printf("ll_i_free=%d\n",ll_i_n_free);
  return ll_i_n_free;
}


struct ll_i_cell* ll_i_create_cell(unsigned int v){
  struct ll_i_cell *ptr = (struct ll_i_cell*)ll_i_malloc(sizeof(struct ll_i_cell));
  ptr->value = v;
  ptr->next = NULL;
  return ptr;
}

Llist_i ll_i_initialize(){
  Llist_i ptr = (Llist_i)ll_i_malloc(sizeof(struct linked_list_i));
  ptr->head = NULL;
  ptr->tail = NULL;
  return ptr;
}

void ll_i_insert_at_tail(Llist_i *l,unsigned int v){
  struct ll_i_cell *ptr = ll_i_create_cell(v);

  if(ptr == NULL) util_error("ll_i_insert_at_tail","creating cell");
  if(*l == NULL){
    *l = ll_i_initialize();
  }
  if(*l == NULL)  util_error("ll_i_insert_at_tail","llist initialization");
  if((*l)->head == NULL){
    (*l)->head = ptr;
    (*l)->tail = (*l)->head;
    return;
  }
  (*l)->tail->next = ptr;
  (*l)->tail = (*l)->tail->next;
}


int ll_i_cell_i_compare(struct ll_i_cell *c1,struct ll_i_cell *c2){
  
  return (c1->value < c2->value);
}

// No tail


void ll_i_insert_sorted(Llist_i *l,unsigned int v){
  struct ll_i_cell* prev, *curr,*temp;
  temp = ll_i_create_cell(v);
  if(temp == NULL) util_error("ll_i_insert_sorted","creating cell");
  if(*l == NULL){
    *l = ll_i_initialize();
  }
  if(*l == NULL) util_error("ll_i_insert_sorted","llist initialization");

  if ( (*l)->head == NULL ){
    (*l)->head = temp;  
  }
  else{
    prev = NULL;
    curr = (*l)->head;
    
    /* traverse the list until the spot
       for insertion is found */
    while (curr != NULL && ll_i_cell_i_compare(curr,temp)){
      prev = curr;
      curr = curr -> next;
    }
    
    /* insert the node, temp */
    if(prev == NULL){
      temp -> next = (*l)->head;
      (*l)->head = temp;
    }
    else{
      prev -> next = temp;
      temp -> next = curr;
    }
  }
}

//find an element in list

struct ll_i_cell* ll_i_find_element(Llist_i l,int elem){
  struct ll_i_cell *ptr;
  if(l == NULL) return NULL;
  ptr = l->head;
  while(ptr != NULL){
    if(ptr->value == elem) return ptr;
     ptr = ptr->next;
  }
  return NULL;
}

void ll_i_print(Llist_i l){
  struct ll_i_cell *ptr;

  if(l == NULL) {
    printf("-- NULL LLIST --\n");
    return;
  }
  ptr = l->head;
  while(ptr != NULL){
    printf("%d ",ptr->value);
    ptr = ptr->next;
  }
}

void ll_i_println(Llist_i l){
  ll_i_print(l);
  printf("\n");
}


void ll_i_free(Llist_i *l){
  struct ll_i_cell *ptr;

  if(*l != NULL){
    while((*l)->head != NULL){
      ptr = (*l)->head;
      (*l)->head = (*l)->head->next;
      ll_i_pfree(ptr);
    }
    ll_i_pfree(*l);
    *l = NULL;
  }
}


int ll_i_length(Llist_i ll){
  struct ll_i_cell *ptr;
  int i = 0;
  if(ll == NULL) return 0;
  ptr = ll->head;
  while(ptr != NULL){
    ptr = ptr->next;
    i++;
  }
  return i;
}

Llist_i ll_i_copy(Llist_i ll){
  Llist_i temp = NULL;
  struct ll_i_cell *ptr;
  if(ll == NULL) return NULL;
  ptr = ll->head;
  while(ptr != NULL){
    ll_i_insert_at_tail(&temp,ptr->value);
    ptr = ptr->next;
  }
 
  return temp;
}
