#include <stdio.h>
#include <malloc.h>
#include "llist_d.h"
#include "utilities.h"

int ll_d_n_free = 0;
int ll_d_n_malloc = 0;

void* ll_d_malloc(int n){
  ll_d_n_malloc++;
  return (void *)malloc(n);
}

void ll_d_pfree(void *ptr){
  if(ptr == NULL) return;
  ll_d_n_free++;
  free(ptr);
  ptr = NULL;
}

int ll_d_print_n_malloc(){
  printf("ll_d_malloc=%d\n",ll_d_n_malloc);
  return ll_d_n_malloc;
}

int ll_d_print_n_free(){
  printf("ll_d_free=%d\n",ll_d_n_free);
  return ll_d_n_free;
}


struct ll_d_cell* ll_d_create_cell(unsigned int k,double v){
  struct ll_d_cell *ptr = (struct ll_d_cell*)ll_d_malloc(sizeof(struct ll_d_cell));
  ptr->key = k;
  ptr->value = v;
  ptr->next = NULL;
  return ptr;
}

Llist_d ll_d_initialize(){
  Llist_d ptr = (Llist_d)ll_d_malloc(sizeof(struct linked_list_d));
  ptr->head = NULL;
  ptr->tail = NULL;
  return ptr;
}

void ll_d_insert_at_tail(Llist_d *l,unsigned int k,double v){
  struct ll_d_cell *ptr = ll_d_create_cell(k,v);

  if(ptr == NULL) util_error("ll_d_insert_at_tail","creating cell");
  if(*l == NULL){
    *l = ll_d_initialize();
  }
  if(*l == NULL) util_error("ll_d_insert_at_tail","list initialization");;
  if((*l)->head == NULL){
    (*l)->head = ptr;
    (*l)->tail = (*l)->head;
    return;
  }
  (*l)->tail->next = ptr;
  (*l)->tail = (*l)->tail->next;
}


int ll_d_cell_compare(struct ll_d_cell *c1,struct ll_d_cell *c2,int option){
  
  if(option == 0){
    return (c1->key < c2->key);
  }
  return (c1->value < c2->value);
}

// No tail

//option = 0 => sorting according to cell keys
//option = 1 => sorting according to cell values

void ll_d_insert_sorted(Llist_d *l,unsigned int k,double v,int option){
  struct ll_d_cell* prev, *curr,*temp;
  temp = ll_d_create_cell(k,v);
  if(temp == NULL) util_error("ll_d_insert_sorted","creating cell");
  if(*l == NULL){
    *l = ll_d_initialize();
  }
  if(*l == NULL) util_error("ll_d_insert_sorted","llist_d initialization");;

  if ( (*l)->head == NULL ){
    (*l)->head = temp;  
  }
  else{
    prev = NULL;
    curr = (*l)->head;
    
    /* traverse the list until the spot
       for insertion is found */
    while (curr != NULL && ll_d_cell_compare(curr,temp,option)){
      prev = curr;
      curr = curr -> next;
    }
    
    /* insert the node, temp */
    if(prev == NULL){
      temp -> next = (*l)->head;
      (*l)->head = temp;
    }
    else{
      prev -> next = temp;
      temp -> next = curr;
    }
  }
}

//find an element in list
//option = 0 => element=key
//option = 1 => element=value

struct ll_d_cell* ll_d_find_element(Llist_d l,double elem,int option){
  struct ll_d_cell *ptr;
  if(l == NULL) return NULL;
  ptr = l->head;
  while(ptr != NULL){
    if(option && (ptr->value == elem)) return ptr;
    if(!option && (ptr->key == elem)) return ptr;
    ptr = ptr->next;
  }
  return NULL;
}

void ll_d_print(Llist_d l){
  struct ll_d_cell *ptr;

  if(l == NULL) {
    printf("-- NULL LLIST --\n");
    return;
  }
  ptr = l->head;
  while(ptr != NULL){
    printf("(%d,%f)",ptr->key,ptr->value);
    ptr = ptr->next;
  }
}

void ll_d_println(Llist_d l){
  ll_d_print(l);
  printf("\n");
}


void ll_d_free(Llist_d *l){
  struct ll_d_cell *ptr;

  if(*l != NULL){
    while((*l)->head != NULL){
      ptr = (*l)->head;
      (*l)->head = (*l)->head->next;
      ll_d_pfree(ptr);
    }
    ll_d_pfree(*l);
    *l = NULL;
  }
}


int ll_d_length(Llist_d ll){
  struct ll_d_cell *ptr;
  int i = 0;
  if(ll == NULL) return 0;
  ptr = ll->head;
  while(ptr != NULL){
    ptr = ptr->next;
    i++;
  }
  return i;
}

