#ifndef _h_ll
#define _h_ll

#define LL_VALUES 1
#define LL_KEYS 0

// HEADER FOR LINKED LIST LIBRARY

//structure of a cell of a linked list

struct ll_cell{
  unsigned int key;
  unsigned int value;
  struct ll_cell *next;
};

struct linked_list{
  struct ll_cell *head;
  struct ll_cell *tail;
};

typedef struct linked_list * Llist; 

//FUNCTIONS

void ll_insert_at_tail(Llist *l,unsigned int k,unsigned int v);
void ll_insert(Llist *l,unsigned int k,unsigned int v); //head 
void ll_insert_sorted(Llist *l,unsigned int k,unsigned int v,int option);//option = 0: sorted according to keys ; according to values otherwise
Llist ll_copy(Llist l);
void ll_add_list_sorted(Llist *l,Llist list);
struct ll_cell* ll_find_element(Llist l,int elem,int option);
int ll_element_exists(Llist l,int key,int value);
void ll_print(Llist l);
void ll_print_keys(Llist l);
void ll_println(Llist l);
void ll_free(Llist *l);
int ll_print_n_malloc();
int ll_print_n_free();
int ll_length(Llist ll);

#endif
