#include <stdio.h>
#include <malloc.h>
#include "llist.h"
#include "utilities.h"

int ll_n_free = 0;
int ll_n_malloc = 0;

void* ll_malloc(int n){
  ll_n_malloc++;
  return (void *)malloc(n);
}

void ll_pfree(void *ptr){
  if(ptr == NULL) return;
  ll_n_free++;
  free(ptr);
  ptr = NULL;
}

int ll_print_n_malloc(){
  printf("ll_malloc=%d\n",ll_n_malloc);
  return ll_n_malloc;
}

int ll_print_n_free(){
  printf("ll_free=%d\n",ll_n_free);
  return ll_n_free;
}


struct ll_cell* ll_create_cell(unsigned int k,unsigned int v){
  struct ll_cell *ptr = (struct ll_cell*)ll_malloc(sizeof(struct ll_cell));
  ptr->key = k;
  ptr->value = v;
  ptr->next = NULL;
  return ptr;
}

Llist ll_initialize(){
  Llist ptr = (Llist)ll_malloc(sizeof(struct linked_list));
  ptr->head = NULL;
  ptr->tail = NULL;
  return ptr;
}

void ll_insert(Llist *l,unsigned int k,unsigned int v){
   struct ll_cell *ptr = ll_create_cell(k,v);

  if(ptr == NULL) util_error("ll_insert_at_tail","creating cell");
  if(*l == NULL){
    *l = ll_initialize();
  }
   if(*l == NULL)  util_error("ll_insert_at_tail","llist initialization");
   ptr->next =(*l)->head;
   (*l)->head = ptr; 
}

void ll_insert_at_tail(Llist *l,unsigned int k,unsigned int v){
  struct ll_cell *ptr = ll_create_cell(k,v);

  if(ptr == NULL) util_error("ll_insert_at_tail","creating cell");
  if(*l == NULL){
    *l = ll_initialize();
  }
  if(*l == NULL)  util_error("ll_insert_at_tail","llist initialization");
  if((*l)->head == NULL){
    (*l)->head = ptr;
    (*l)->tail = (*l)->head;
    return;
  }
  (*l)->tail->next = ptr;
  (*l)->tail = (*l)->tail->next;
}


int ll_cell_compare(struct ll_cell *c1,struct ll_cell *c2,int option){
  if((c1 == NULL) || (c2 == NULL)) return 0;

  if(option == LL_KEYS){
    if(c1->key == c2->key) return (c1->value < c2->value);
    return (c1->key < c2->key);
  }
  if(c1->value == c2->value) return (c1->key < c2->key);
  return (c1->value < c2->value);
}

// No tail

//option = 0 => sorting according to cell keys
//option = 1 => sorting according to cell values

void ll_insert_sorted(Llist *l,unsigned int k,unsigned int v,int option){
  struct ll_cell* prev, *curr,*temp;
  temp = ll_create_cell(k,v);
  if(temp == NULL) util_error("ll_insert_sorted","creating cell");
  if(*l == NULL){
    *l = ll_initialize();
  }
  if(*l == NULL) util_error("ll_insert_sorted","llist initialization");

  if ( (*l)->head == NULL ){
    (*l)->head = temp;  
  }
  else{
    prev = NULL;
    curr = (*l)->head;
    
    /* traverse the list until the spot
       for insertion is found */
    while (curr != NULL && ll_cell_compare(curr,temp,option)){
      prev = curr;
      curr = curr -> next;
    }
    
    /* insert the node, temp */
    if(prev == NULL){
      temp -> next = (*l)->head;
      (*l)->head = temp;
    }
    else{
      prev -> next = temp;
      temp -> next = curr;
    }
  }
}

Llist ll_copy(Llist l){
  Llist res = NULL;
  struct ll_cell *ptr;
  if(l == NULL) return NULL;
  ptr = l->head;
  while(ptr != NULL){
    ll_insert_at_tail(&res,ptr->key,ptr->value);
    ptr = ptr->next;
  }
  return res;
}


void ll_add_list_sorted(Llist *l,Llist list){
  struct ll_cell *ptr;
  if(list == NULL) return;
  ptr = list->head;
  while(ptr != NULL){
    ll_insert_sorted(l,ptr->key,ptr->value,LL_KEYS);
    ptr = ptr->next;
  }
}


//find an element in list
//option = 0 => element=key
//option = 1 => element=value

struct ll_cell* ll_find_element(Llist l,int elem,int option){
  struct ll_cell *ptr;
  if(l == NULL) return NULL;
  ptr = l->head;
  while(ptr != NULL){
    if(option && (ptr->value == elem)) return ptr;
    if(!option && (ptr->key == elem)) return ptr;
    ptr = ptr->next;
  }
  return NULL;
}

int ll_element_exists(Llist l,int key,int value){
  struct ll_cell *ptr;
  if(l == NULL) return 0;
  ptr = l->head;
  while(ptr != NULL){
    if((ptr->value == value) && (ptr->key == key)) return 1;
    ptr = ptr->next;
  }
  return 0;
}



void ll_print(Llist l){
  struct ll_cell *ptr;

  if(l == NULL) {
    printf("-- NULL LLIST --\n");
    return;
  }
  ptr = l->head;
  while(ptr != NULL){
    printf("(%d,%d)",ptr->key,ptr->value);
    ptr = ptr->next;
  }
}


void ll_print_keys(Llist l){
 struct ll_cell *ptr;

  if(l == NULL) {
    printf("-- NULL LLIST --\n");
    return;
  }
  ptr = l->head;
  while(ptr != NULL){
    printf("%d ",ptr->key);
    ptr = ptr->next;
  }
  printf("\n");
}


void ll_println(Llist l){
  ll_print(l);
  printf("\n");
}


void ll_free(Llist *l){
  struct ll_cell *ptr;

  if(*l != NULL){
    while((*l)->head != NULL){
      ptr = (*l)->head;
      (*l)->head = (*l)->head->next;
      ll_pfree(ptr);
    }
    ll_pfree(*l);
    *l = NULL;
  }
}


int ll_length(Llist ll){
  struct ll_cell *ptr;
  int i = 0;
  if(ll == NULL) return 0;
  ptr = ll->head;
  while(ptr != NULL){
    ptr = ptr->next;
    i++;
  }
  return i;
}

