#include "lexicon2.h"
#include "utilities.h"
#include <malloc.h>

int lex2_n_free = 0;
int lex2_n_malloc = 0;

void* lex2_malloc(int n){
  lex2_n_malloc++;
  return (void *)malloc(n);
}

void lex2_pfree(void *ptr){
  if(ptr == NULL) return;
  lex2_n_free++;
  free(ptr);
  ptr = NULL;
}

int lex2_print_n_malloc(){
  printf("lex2_malloc=%d\n",lex2_n_malloc);
  return lex2_n_malloc;
}

int lex2_print_n_free(){
  printf("lex2_free=%d\n",lex2_n_free);
  return lex2_n_free;
}

Lexicon2 lex2_init(){
  Lexicon2 lex =(Lexicon2)lex2_malloc(sizeof(struct lexicon2)); 
  if(lex == NULL) util_error("lex2_init","initialization of lexicon");
  lex->n_elements = 0;
  lex->tree_lexicon = tree2_init();
  lex->tab_lexicon = NULL;
  return lex;
}

void lex2_assign_value_in_tab(Tree2_node **tab,int n,Tree2_node ptr){
  if(*tab == NULL){
    *tab = (Tree2_node *)lex2_malloc((n + 1) * sizeof(Tree2_node));    
  }
  else{
    *tab = (Tree2_node *)realloc(*tab,(n + 1) * sizeof(Tree2_node));
  }
  (*tab)[n] = ptr;
}


int lex2_add_element(Lexicon2 *lex,Ustring u){
  Tree2_node ptr;
  int id;

  if(*lex == NULL){
    *lex = lex2_init();
  }
  if((id = tree2_word_exists((*lex)->tree_lexicon,u)) == -1){
    ptr = tree2_insert_word(&((*lex)->tree_lexicon),u,(*lex)->n_elements);
    lex2_assign_value_in_tab(&((*lex)->tab_lexicon),(*lex)->n_elements,ptr);
    id = (*lex)->n_elements;
    ((*lex)->n_elements)++;
  }  
  return id;
}

Ustring lex2_get_value_in_tab(Tree2_node *tab,int index,int n){
  if(tab == NULL) return NULL;
  if(index >= n) return NULL;
  return tree2_get_element(tab[index]);
}

Ustring lex2_get_element(Lexicon2 lex,int index){
  return lex2_get_value_in_tab(lex->tab_lexicon,index,lex->n_elements);
}

int lex2_get_index(Lexicon2 lex,Ustring u){
  return tree2_word_exists(lex->tree_lexicon,u);
}


void lex2_print_tab(Tree2_node *tab,int n){
  int i;
  Ustring u;
  for(i = 0 ; i < n ; i++){
    u = tree2_get_element(tab[i]);
    ustring_println(u);
    ustring_free(u);
  }
}

void lex2_print_tab2(Tree2_node *tab,int n){
  int i;
  Ustring u;
  for(i = 0 ; i < n ; i++){
    u = tree2_get_element(tab[i]);
    ustring_println2(u);
    ustring_free(u);
  }
}

void lex2_print(Lexicon2 lex){
  if(lex == NULL){
    printf("Empty lexicon\n");
    return;
  }
  lex2_print_tab(lex->tab_lexicon,lex->n_elements);
}

void lex2_println2(Lexicon2 lex){
  if(lex == NULL){
    printf("Empty lexicon\n");
    return;
  }
  lex2_print_tab2(lex->tab_lexicon,lex->n_elements);
}


void lex2_println(Lexicon2 lex){
  lex2_print(lex);
}


void lex2_free(Lexicon2 *lex){
  if(*lex == NULL) return;
  lex2_pfree((*lex)->tab_lexicon);
  tree2_free(&((*lex)->tree_lexicon));
  lex2_pfree(*lex);
}
