#include <stdio.h>
#include <malloc.h>
#include "hashtable.h"
#include "utilities.h"

int hash_n_free = 0;
int hash_n_malloc = 0;

void* hash_malloc(int n){
  hash_n_malloc++;
  return (void *)malloc(n);
}

void hash_pfree(void *ptr){
  if(ptr == NULL) return;
  hash_n_free++;
  free(ptr);
  ptr = NULL;
}

int hash_print_n_malloc(){
  printf("hash_malloc=%d\n",hash_n_malloc);
  return hash_n_malloc;
}

int hash_print_n_free(){
  printf("hash_free=%d\n",hash_n_free);
  return hash_n_free;
}

Hashtable hash_init(int l){
  Hashtable ht;
  int i;

  ht = (Hashtable)hash_malloc(sizeof(struct hashtable));
  if(ht == NULL) util_error("hash_init","cannot init hashtable");
  ht->length = l;
  ht->table = (Llist_t *)hash_malloc(l*sizeof(Llist_t));
  for(i = 0 ; i < l ; i ++) ht->table[i] = NULL;
  
  return ht;
}

void hash_add_element(Hashtable *ht,int key,int value,int id){
  int rid = key%((*ht)->length);
  if(*ht == NULL) util_error("hash_add_element","hashtable not initialized");
  ll_t_insert_sorted(&((*ht)->table[rid]),key,value,id,0);  
}

int hash_get_id(Hashtable ht,int key,int value){
  int rid = key%(ht->length);
  struct ll_t_cell* ptr = ll_t_find_element2(ht->table[rid],key,value);
  if(ptr == NULL) return -1;
  return ptr->id;
}


//in case that key is not found, return 0

int hash_get_value(Hashtable ht,int key){
   int rid = key%(ht->length);
  struct ll_t_cell* ptr = ll_t_find_element(ht->table[rid],key,0);
  if(ptr == NULL) return 0;
  return ptr->value;
}

Llist_i hash_get_keys(Hashtable ht){
  Llist_i res = NULL;
  struct ll_t_cell *ptr;
  Llist_t l;
  int i;

  if(ht == NULL) return NULL;
   for(i = 0 ; i < ht->length ; i++){
     l = ht->table[i];
     if(l != NULL){
       ptr = l->head;
       while(ptr != NULL){
	 ll_i_insert_at_tail(&res,ptr->key);
	 ptr = ptr->next;
       }       
    }
  }
  return res;
}


void hash_print(Hashtable ht){
  int i;
  if(ht == NULL){
    printf("{empty hashtable}\n");
    return;
  }

  for(i = 0 ; i < ht->length ; i++){
    if(ht->table[i] != NULL){
      printf("[id=%d]::",i);
      ll_t_println(ht->table[i]);
    }
  }
}

void hash_println(Hashtable ht){
  hash_print(ht);
}

void hash_free(Hashtable ht){
  int i;
  if(ht == NULL) return;
  
  for(i = 0 ; i < ht->length ; i++){
    ll_t_free(&(ht->table[i]));
  }
  hash_pfree(ht->table);
  hash_pfree(ht);
}
