#ifndef _h_grf
#define _h_grf
#include "grammar.h"
#include "ustring.h"
#include "llist.h"
#include "tree.h"

// temporary graph structure

struct grf_graph{
  int n_boxes;
  int *n_elements; //number of elements in each box
  Ustring **contents; // content of the boxes
  Llist *edges; // edges between boxes
};

typedef struct grf_graph *Grf_graph; 


struct grf_context{
  struct grf_graph * graphs[N_AUTOMATA_MAX];
  char *graph_names[N_AUTOMATA_MAX];
  Ustring terminals[N_TERMINALS_MAX];
  Tree_node tree_names;
  Tree_node tree_terminals;
  int n_graphs;
  int n_terminals;
  int current_graph;
  int option; //unitex format ; intex format
  char default_path[USTRING_LENGTH_MAX];
  char *tokenizer;
};


//Funtions

Grammar grf_load_graph(char *name,int option,char * tokenizer);


#endif
