// C module to load a graph at the grf format into automaton  

#include <stdio.h>
#include "grf.h"
#include "grammar.h"
#include "ustring.h"
#include "llist.h"
#include "tree.h"
#include "utilities.h"

#define GRF_N_TOKENS_MAX 10000



Ustring grf_get_line(FILE *f, int option){
  Uchar temp[USTRING_LENGTH_MAX];
  Ustring ustr;
  int i = 0,end_line = 0;
  for(i = 0 ; (i < USTRING_LENGTH_MAX) && !end_line  ; i++){
    temp[i] = ustring_read_uchar(f,option);
    if(temp[i] == '\n') end_line = 1;
    if(temp[i] == EOF) return NULL;
  }
  if(i == USTRING_LENGTH_MAX) return NULL;
  temp[i - 1] = 0;
  ustr = ustring_allocation(temp);
  return ustr;
}


void grf_get_header(FILE *f,int option){
  Ustring line;
  char stop = 0,first = 1;
  
  while(!stop){
    line = grf_get_line(f,option);
    if(line == NULL){ 
      stop = 1;
    }
    else{
      //      ustring_println(line);
      if(!first){
	if(line[0] == '#') stop = 1;
      }
      else{
	first = 0;
      }
      ustring_free(line);
    }
  }
}

int grf_get_content(Ustring box,Uchar cont[]){
  int i = 1,end = 0;
  while(!end){
    if((box[i] != '"') || (box[i - 1]) == '\\'){ //DESPECIALIZED CHAR : TODO 
      cont[i - 1] = box[i];
    }
    else{
      end = 1;
      cont[i - 1] = 0;
    }
    i++;
  }
  return i;
}

int grf_update_context(Ustring u,struct grf_context *context){
  Ustring ustr;
  char substr[USTRING_LENGTH_MAX],s2[USTRING_LENGTH_MAX];
  char *s;
  int i;

  s = ustring_to_string(u);
  util_substr(s,1,strlen(s),substr);
  strcpy(s2,context->default_path);
  strcat(s2,substr); //TODO test if not reference to another directory
  strcat(s2,".grf");
  ustr = ustring_from_string(s2);
  if((i = tree_word_exists(context->tree_names,ustr)) == -1){
    (context->n_graphs)++;
    if(context->n_graphs == N_AUTOMATA_MAX) return 1;
    tree_insert_word(&(context->tree_names),ustr,(context->n_graphs) - 1);
    context->graph_names[(context->n_graphs) - 1] = util_alloc_string(s2);
  }
  free(s);
  ustring_free(ustr);
  return 0;
}


Ustring * grf_tokenize_content(Uchar cont[], struct grf_context *context,int index_box){
  Uchar temp[USTRING_LENGTH_MAX];
  Ustring u[GRF_N_TOKENS_MAX];
  Ustring *res;
  int i,j=0,k=0,end = 0;
  //TODO switch according to context->tokenizer

  for(i = 0 ; !end ; i++){
    if(((cont[i] == '+') && (cont[i - 1] != '\\')) || (cont[i] == 0)){
      temp[k] = 0;
      u[j] = ustring_allocation(temp);
      if(tree_word_exists(context->tree_terminals,u[j]) == -1){
	(context->n_terminals)++;
	if(context->n_terminals == N_TERMINALS_MAX) return NULL;
	tree_insert_word(&(context->tree_terminals),u[j],(context->n_terminals) - 1);
	context->terminals[(context->n_terminals) - 1] =  ustring_allocation(u[j]);
      }
      if(cont[i] == 0) end = 1;
      j++;
      k=0;
    }
    else{
      temp[k] = cont[i];
      k++;      
    }      
  }
  context->graphs[context->current_graph]->n_elements[index_box] = i;
  res = (Ustring *)malloc((j + 1)*sizeof(Ustring));
  for(i = 0 ; i < j ; i++){
    if(u[i][0] == ':'){
      grf_update_context(u[i],context);
    }
    res[i] = u[i];
  }
  res[j] = NULL;
  return res;
}

void grf_get_edges(Llist *edges,Ustring box,int pos){
  int n,i;
  
  ustring_get_next_int(box,&pos);
  ustring_get_next_int(box,&pos);
  n = ustring_get_next_int(box,&pos);
  for(i = 0 ; i < n ; i++){
    ll_insert_at_tail(edges,ustring_get_next_int(box,&pos),0);
  }
}

void grf_get_box_info(struct grf_graph **g,int pos,Ustring box,struct grf_context *context){
  Uchar content[USTRING_LENGTH_MAX];
  int i;

  i = grf_get_content(box,content);
   (*g)->contents[pos] = grf_tokenize_content(content,context,pos);
   (*g)->edges[pos] = NULL;
   grf_get_edges(&((*g)->edges[pos]),box,i);
}


struct grf_graph* grf_get_graph(FILE *f,struct grf_context *context){
  Ustring line;
  int i,option;
  struct grf_graph * g = (struct grf_graph *)malloc(sizeof(struct grf_graph));
  if(g == NULL) return NULL;
  option = context->option;
  line = grf_get_line(f,option);
  g->n_boxes = ustring_to_int(line);
  ustring_free(line);
  g->contents = (Ustring **)malloc(g->n_boxes * sizeof(Ustring *));
  g->edges = (Llist *)malloc(g->n_boxes * sizeof(Ustring *));
  g->n_elements = (int *)malloc(g->n_boxes * sizeof(int));
  for(i = 0 ; i < g->n_boxes ; i++){
    line = grf_get_line(f,option);
    grf_get_box_info(&g,i,line,context);
    ustring_free(line);
  }
  /*for(i = 0 ; i < g->n_boxes ; i++){
      ustring_print_array(g->contents[i]);
      ll_print(g->edges[i]);
      }*/
  return g;
}


void grf_load_one_graph(struct grf_context *context){
  FILE *f;
  char *name = context->graph_names[context->current_graph];

  f = fopen(name,"r");
  if(f == NULL){
    context->graphs[context->current_graph] = NULL;
    printf("Cannot open %s\n",name);
    return;
  }
  grf_get_header(f,context->option);
  context->graphs[context->current_graph] = grf_get_graph(f,context);
  fclose(f);
}

void grf_initialize_context(struct grf_context *context,char *name,char *tokenizer,int option){
  Ustring u;

  context->current_graph = 0;
  context->n_graphs = 1;
  context->n_terminals = 1;
  context->tree_names = tree_initialize();
  context->tree_terminals = tree_initialize();
  u = ustring_from_string(name);
  tree_insert_word(&(context->tree_names),u,0);
  ustring_free(u);
  u = ustring_from_string("<E>");
  tree_insert_word(&(context->tree_terminals),u,EPSILON);
  context->terminals[0] = u;
  context->graph_names[0] = name;
  context->option = option;
  context->tokenizer = tokenizer;
  util_get_path(name,context->default_path);
}

int grf_get_element_index(int*isterminal,Ustring u,struct grf_context *context){

  return 0;
}


int grf_add_multiple_transitions(Automaton *aut,int start,int dest,struct grf_context *context){
  State st = (*aut)->states[start];
  int tag,n_elements,i,isterminal;
  n_elements = context->graphs[context->current_graph]->n_elements[dest - 1];
  for(i = 0 ; i < n_elements ; i++){
    tag = grf_get_element_index(&isterminal,context->graphs[context->current_graph]->contents[dest][i],context);
    auto_add_transition(aut,start,isterminal,tag,dest);
  }
  return 0;
}


Automaton  grf_create_automaton(int index_grf,struct grf_context *context){
  Automaton aut = NULL;
  struct grf_graph *g;
  g = context->graphs[index_grf];

  if(auto_init_automaton_states(&aut,g->n_boxes)) return NULL;
  auto_set_initial_state(aut->states[0]);
  grf_add_multiple_transitions(&aut,0,1,context);

  return aut;
}


// load a grf graph 
//option = 0 => unitex format
//option = 1 => intex format
//tokenizer = name of the tokenizer for box 
//(if NULL, use of default tokenizer => tokens are separated by + symbols)

Grammar grf_load_graph(char *name,int option, char *tokenizer){
  struct grf_context context;
  Grammar gram = NULL;
  int i;

  grf_initialize_context(&context,name,tokenizer,option);
  while(context.current_graph < context.n_graphs){
    grf_load_one_graph(&context);
    (context.current_graph)++;
  }
  for(i = 0 ; i < context.n_graphs ; i++){
    printf("%s=%p\n",context.graph_names[i],context.graphs[i]);
  }
  gram = gram_init_grammar(context.n_graphs);
  for(i = 0 ; i < context.n_graphs ; i++){
    gram->automata[i] = grf_create_automaton(i,&context);
  }
  return NULL;
}
