#ifndef _h_dico 
#define _h_dico

#include "lexicon.h"
#include "tab_ll.h"
#include "tab_l.h"
#include "tab_i.h"
#include "tokens.h"
#include "hashtable.h"

#define DICO_COMPOUNDS 1
#define DICO_SIMPLE_WORDS 0


struct dico_config{
  Lexicon categories;
  Tab_l cat_features;
  Tab_l default_features;
  Hashtable hash_cat;
};

typedef struct dico_config *Dico_config;

struct dico{
  Dico_config config;
  Tab_ll simple_features;
  Lexicon compound_lexicon;
  Tab_ll compound_features;
};

typedef struct dico *Dico;

//functions

int dico_print_n_malloc();
int dico_print_n_free();
void dico_load(Dico *dic,char *dico_name,int has_ascii_format,Tokens* tokens);
void dico_free(Dico *dic);
//void dico_print(Dico dic);
#endif
