#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>



#include "table.h"
#include "utilities.h"

void malloc_free_statistics(){
  int n_malloc = 0;
  int n_free = 0;
  
  printf("=== MALLOC/FREE ===\n");
  //  n_malloc += ll_print_n_malloc();
  //n_free += ll_print_n_free();
  //n_malloc += ll_d_print_n_malloc();
  //n_free += ll_d_print_n_free();
  //n_malloc += ll_t_print_n_malloc();
  //n_free += ll_t_print_n_free();
  //n_malloc += ll_i_print_n_malloc();
  //n_free += ll_i_print_n_free();
  //n_malloc += tree_print_n_malloc();
  //n_free += tree_print_n_free();
  //n_malloc += tree2_print_n_malloc();
  //n_free += tree2_print_n_free();
  //n_malloc += stree2_print_n_malloc();
  //n_free += stree2_print_n_free();
  n_malloc += ustring_print_n_malloc();
  n_free += ustring_print_n_free();
  n_malloc += tab_u_print_n_malloc();
  n_free += tab_u_print_n_free();
  n_malloc += util_print_n_malloc();
  n_free += util_print_n_free();
  n_malloc += lex_print_n_malloc();
  n_free += lex_print_n_free();
  n_malloc += table_print_n_malloc();
  n_free += table_print_n_free();

  printf("---------------\n");
  printf("n_malloc=%d\n",n_malloc);
  printf("n_free=%d\n",n_free);
  printf("====  ===  ====\n");
}

Tab_u comp_load_reference_grf(char *name,int encoding){
  Tab_u temp = NULL;
  Ustring line;
  FILE *f;
  int i = 0;

  f = fopen(name, "r");
  if(f == NULL) util_error("comp_load_reference_grf","cannot open reference graph");

  fgetc(f);
  fgetc(f);
  while((line = ustring_get_line(f,encoding)) != NULL){
    tab_u_assign_value(&temp,i,line);
    ustring_free(line);
    i++;
  }  
  return temp;
}

int comp_is_box(Ustring line){
  return (ustring_get_uchar(line,0) == (Uchar)'"');
}

int comp_is_parameter(int index){
  return (index % 2);
}


Ustring comp_process_parameter(Table tab, int row, Ustring parameter){
  return table_resolve_parameter(tab,row,parameter);
}

Ustring comp_process_meta_parameter(Table tab, int row, Ustring parameter){
  return table_resolve_meta_parameter(tab,row,parameter);
}

int comp_box_has_meta_parameter(Tab_u box){
  int i,n = tab_u_get_n_elements(box);
  Ustring val;

  for(i = 0 ; i < n ; i++){
    val = tab_u_get_value(box,i);
    if(comp_is_parameter(i) && (ustring_get_uchar(val,0) == '#')){
      return 1;
    }
  }
  return 0;
}


Ustring comp_fill_box_content(Table tab,int row,Ustring box){
  Ustring u = NULL,val,v;
  int i;
  Tab_u split;

  split = ustring_split((Uchar)'@',box); 
// attention, ca ne marche pas toujours
  
// Assumption : if there is a meta parameter in the box, there must be only meta paranters in it 

// get if there is a parameter starting with #
  if(!comp_box_has_meta_parameter(split)){
    tab_u_free(&split);
    return box;
  }

  for(i = 0 ; i < tab_u_get_n_elements(split); i++){
    val = tab_u_get_value(split,i);
    if(comp_is_parameter(i)){
      //      ustring_println(val);
      v = comp_process_meta_parameter(tab,row,val);
      // ustring_println(v);
      if(v == NULL){
	ustring_free(u);
	tab_u_free(&split);
	return NULL;
      }
      ustring_strcat(&u,v);
      ustring_free(v);
    }
    else{
      ustring_strcat(&u,val);
    }
  }
  tab_u_free(&split);
  return u;
}


void comp_get_box_position(Ustring box,int *x,int *y){
  int pos = ustring_find_last(box,(Uchar)'"');
  if(pos == -1) util_error("comp_get_box_position","cannot find \" in the box line");
  *x = ustring_get_next_int(box,&pos);
  *y = ustring_get_next_int(box,&pos);
}


void comp_process_box(FILE * f,Table tab,int row,Ustring line){
  Ustring box,ufail;
  int x,y,max = 10000;
  char fail[max];

  box = comp_fill_box_content(tab,row,line);
  //printf("WWWW=");ustring_println(box);
  if(box != NULL){ //succes
    ustring_writeln_utf_16(f,box);
    //printf("BBBOX=");ustring_println(box);
    ustring_free(box);
  }
  else{
    comp_get_box_position(line,&x,&y);
    snprintf(fail,max,"\"<E>\" %d %d 0 ",x,y);
    ufail = ustring_from_string(fail);
    //  ustring_println(ufail);
    ustring_writeln_utf_16(f,ufail);
    ustring_free(ufail);
  }

}


void comp_process_grf(Table tab,int row,char *src,char *dest_path,Tab_u grf){

  //int f = open(dest_path,O_WRONLY|O_CREAT|O_TRUNC,00644);
  FILE * f = fopen(dest_path, "w");
  int i,n = tab_u_get_n_elements(grf);
  Ustring line = NULL;

  //  printf("name=%s\n",dest_path);
  //if(f == -1) util_error("comp_process_grf","cannot open new grf file");
  if(f == NULL) util_error("comp_process_grf","cannot open new grf file");

  ustring_write_starting_mark(f); 
  for(i = 0 ; i < n ; i++){ // for each line
    //printf("OUTCH\n");
    line = ustring_allocation(tab_u_get_value(grf,i));
    //printf("Line=");ustring_println(line);
    if(comp_is_box(line)){
      comp_process_box(f,tab,row,line);
    }
    else{
      ustring_writeln_utf_16(f,line);
    }
    //printf("Line2=");ustring_println(line);
    //ustring_free(line);
  }
  fclose(f);
}


void comp_build_main_grf(char *name, Ustring content) {

  Ustring u;
  int i;

  int content_size = ustring_length(content);

  int nbbox = content_size / 5000 + 1;

  //  int f = open(name,O_WRONLY|O_CREAT|O_TRUNC,00644);
  FILE * f = fopen(name, "w");

  ustring_write_starting_mark(f);
  ustring_writeln_utf_16_from_string(f,"#Unigraph");
  ustring_writeln_utf_16_from_string(f,"SIZE 1188 840");
  ustring_writeln_utf_16_from_string(f,"FONT Times New Roman:  10");
  ustring_writeln_utf_16_from_string(f,"OFONT Times New Roman:B 12");
  ustring_writeln_utf_16_from_string(f,"BCOLOR 16777215");
  ustring_writeln_utf_16_from_string(f,"FCOLOR 0");
  ustring_writeln_utf_16_from_string(f,"ACOLOR 10066329");
  ustring_writeln_utf_16_from_string(f,"SCOLOR 16711680");
  ustring_writeln_utf_16_from_string(f,"CCOLOR 255");
  ustring_writeln_utf_16_from_string(f,"DBOXES y");
  ustring_writeln_utf_16_from_string(f,"DFRAME y");
  ustring_writeln_utf_16_from_string(f,"DDATE y");
  ustring_writeln_utf_16_from_string(f,"DFILE y");
  ustring_writeln_utf_16_from_string(f,"DDIR n");
  ustring_writeln_utf_16_from_string(f,"DRIG n");
  ustring_writeln_utf_16_from_string(f,"DRST n");
  ustring_writeln_utf_16_from_string(f,"FITS 100");
  ustring_writeln_utf_16_from_string(f,"PORIENT L");
  ustring_writeln_utf_16_from_string(f,"#");

  char buf[16];
  sprintf(buf, "%d", nbbox + 2);
  ustring_writeln_utf_16_from_string(f,buf);

  ustring_write_utf_16_from_string(f,"\"<E>\" 69 199 ");
  sprintf(buf, "%d ", nbbox);
  ustring_write_utf_16_from_string(f,buf);
  for (i = 0; i < nbbox; i++) {
    sprintf(buf, "%d ", i + 2);
    ustring_write_utf_16_from_string(f,buf);
  }
  ustring_writeln_utf_16_from_string(f,"");

  ustring_writeln_utf_16_from_string(f,"\"\" 466 199 0 ");

  int pos = 0;

  for (i = 0; i < nbbox && pos < content_size; ++i) {  

    int end = pos + 5000;
    if (end > content_size) { end = content_size; }

    while (content[end] && content[end] != '+') { end++; }


    u = ustring_from_string("\"");
    ustring_write_utf_16(f,u);
    ustring_free(u);
  
    u = ustring_get_substr(content, pos, end); 
    ustring_write_utf_16(f, u);
    ustring_free(u);
    
    u = ustring_from_string("\" 215 199 1 1 ");
    ustring_writeln_utf_16(f,u);
    ustring_free(u);
    pos = end + 1;
  }

  while (i < nbbox) {
    ustring_writeln_utf_16_from_string(f,"\"<E>\" 69 199 0 ");
    ++i;
  }
  
  fclose(f);
}

void remove_diacritics(char * text) {

  while (*text) {
  
    switch (*text) {
    case '':
    case '':
    case '':
      *text = 'a';
      break;
    case '':
    case '':
    case '':
    case '':
      *text = 'e';
      break;
    case '':
    case '':
      *text = 'i';
      break;
    case '':
    case '':
      *text = 'o';
      break;
    case '':
    case '':
      *text = 'u';
      break;
    }
    ++text;
  }
}


void comp_build_name_grf(Table tab,char name[],char *suffix,char dir[], char * basename, int row,int max){

  Ustring param,val;
  char *value;

  if (suffix != NULL) {
    param = ustring_from_string(suffix);
    val = table_get_value(tab,row,param);

    if (val == NULL) { // if suffix is not a table title, put it litteraly
      value = suffix;
      util_warning("comp_build_name_grf","suffix is not a table header");
    } else {
      value = ustring_to_string(val);
    }
    snprintf (name, max,"%s/%s.grf",dir, value);
    ustring_pfree(value);
    remove_diacritics(name);
    return;
  }
  util_error("comp_build_name_grf","suffix should not be null");
  snprintf (name, max,"%s/%s-%d.grf",dir, basename, row);
  remove_diacritics(name);
}

Ustring comp_process_ref(Table tab,char *ref,char *dir,char* basename, char * suffix, int encoding){

  int i,n = table_get_n_rows(tab),max = 500000;
  char name_grf[max],grf_content[max],short_name[max];
  
  grf_content[0] = 0;
  Tab_u temp = comp_load_reference_grf(ref,encoding);
  for(i = 1 ; i <= n ; i++){ 

    comp_build_name_grf(tab,name_grf,suffix,dir, basename, i, max);
    //    printf("%s\n",name_grf);
    comp_process_grf(tab,i,ref,name_grf,temp);
    if (grf_content[0]) strcat(grf_content, "+");
    strcat(grf_content,":");
    util_get_filename(name_grf,short_name);
    // remove .grf
    short_name[strlen(short_name) - 4] = 0;
    //printf("shortname=%s\n", short_name);
    strcat(grf_content,short_name);    
  }
  tab_u_free(&temp);
  return ustring_from_string(grf_content);
}


void comp_process(Table tab,char *main_grf,char *ref,char *dir,char* basename, char * suffix, int encoding){
 
  char buf[1024];
  sprintf(buf, "%s/%s.grf", dir, main_grf);
  Ustring content = comp_process_ref(tab, ref, dir, basename, suffix, encoding);
  comp_build_main_grf(buf,content);
}

void comp_list(Table tab,char *main_grf,char *list,char *dir, char * suffix, int encoding){

  FILE * f = fopen(list, "r");
  char buf[1024],path[1024];

  
  if (f ==NULL) {
    util_error("complist", "cannot open file");    
  }
  util_get_path(list,path);
  if(strlen(path)) strcat(path,"/");

  Ustring content = NULL;
  while (fgets(buf, 1024, f)) {

    char ref[1024];
    buf[strlen(buf) - 1] = 0;
    strcpy(ref,path);
    strcat(ref, buf);
    strcat(ref, ".grf");
    Ustring tmp = comp_process_ref(tab, ref, dir, buf, suffix, encoding);
    
    /* printf("tmp="); ustring_println(tmp);*/
    if (content) { ustring_append(&content, '+'); }
    ustring_strcat(& content, tmp);
    ustring_free(tmp);
  }
  
  //printf("content="); ustring_println(content);
  
  sprintf(buf, "%s/%s.grf", dir, main_grf);
  comp_build_main_grf(buf,content);
}


char * progname;

void usage() {
  printf("usage: %s -table <table> [-conf <config>] [-one|-two] "
         "-dir <destdir> [-sfx <suffix>] -main <main_grf> [-grf|-list] <reference>\n",
         progname);
  exit(0);
}


int main(int argc, char**argv){

  /*
  int max = 10000,
  char config[max];
  */

  char * tablename = NULL, * config = NULL, * dir = NULL, * suffix = "entry";
  char * maingrf = NULL, * reference = NULL, * reflist = NULL;
  int n_headers = TABLE_TWO_ROW_HEADER;
  Table tab;


  progname = *argv;
  argv++, argc--;

  
  if (argc == 0){
    usage();
    //fprintf(stderr,"usage:\n./compile <table> <config> <number of headers> <reference> <main_grf> <grf_name_prefix> <suffix>\ncd README_compile\n");
    //return 1;
  }

  while (argc) {

    if (strcmp(*argv, "-table") == 0) {

      argv++, argc--;
      if (! argc) { fprintf(stderr, "bad args\n"); exit(1); }
      tablename = *argv;
    
    } else if (strcmp(*argv, "-conf") == 0) {

      argv++, argc--;
      if (! argc) { fprintf(stderr, "bad args\n"); exit(1); }
      config = *argv;
    
    } else if (strcmp(*argv, "-dir") == 0) {

      argv++, argc--;
      if (! argc) { fprintf(stderr, "bad args\n"); exit(1); }
      dir = *argv;
    
    } else if (strcmp(*argv, "-sfx") == 0) {

      argv++, argc--;
      if (! argc) { fprintf(stderr, "bad args\n"); exit(1); }
      suffix = *argv;
    
    } else if (strcmp(*argv, "-main") == 0) {

      argv++, argc--;
      if (! argc) { fprintf(stderr, "bad args\n"); exit(1); }
      maingrf = *argv;
    
    } else if (strcmp(*argv, "-grf") == 0) {

      argv++, argc--;
      if (! argc) { fprintf(stderr, "bad args\n"); exit(1); }
      reference = *argv;
    
    } else if (strcmp(*argv, "-list") == 0) {

      argv++, argc--;
      if (! argc) { fprintf(stderr, "bad args\n"); exit(1); }
      reflist = *argv;
    
    } else if (strcmp(*argv, "-one") == 0) {

      n_headers = TABLE_ONE_ROW_HEADER;

    } else if (strcmp(*argv, "-two") == 0) {

      n_headers = TABLE_TWO_ROW_HEADER;

    } else if (strcmp(*argv, "-help") == 0) {

      usage();

    } else { reference = *argv; }
  
    argv++, argc--;
  }


  if (tablename == NULL || maingrf == NULL || (reference == NULL && reflist == NULL)) {
    fprintf(stderr, "missing some argument\n");
    exit(1);
  }
  
  //  if (prefix == NULL) { prefix = maingrf;  }

  /*
  if(!strcmp(argv[3],"ONE")) n_headers = TABLE_ONE_ROW_HEADER;
  else n_headers = TABLE_TWO_ROW_HEADER;
  if(!strcmp(argv[2],"NULL")) tab = table_load(argv[1],NULL,ASCII_FORMAT,n_headers);
  else tab = table_load(argv[1],argv[2],ASCII_FORMAT,n_headers);
  */

  printf("loading table...\n");
  tab = table_load(tablename, config, ASCII_FORMAT, n_headers);

  char basename[1024];
  /*
  if(!strcmp(argv[7],"NULL")) comp_process(tab,argv[5],argv[4],argv[6],NULL,UNICODE_FORMAT);
  else comp_process(tab,argv[5],argv[4],argv[6],argv[7],UNICODE_FORMAT);
  */
  printf("processing...\n");
  if (reference) {
    util_get_filename(reference, basename);
    assert(strcmp(basename + strlen(basename) - 4, ".grf") == 0);
    basename[strlen(basename) - 4] = 0;
    comp_process(tab, maingrf, reference, dir, basename, suffix, UNICODE_FORMAT);
  } else {
    comp_list(tab, maingrf, reflist, dir, suffix, UNICODE_FORMAT);
  }

  printf("ok.\n");
  table_free(&tab);
  return 0;
}

